/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.apes.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson2.JSON;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.common.http.SapsViewHttpClient;
import com.xdja.saps.view.common.http.bean.HttpResult;
import com.xdja.saps.view.data.apes.enums.ApesInterfaceTypeEnum;
import com.xdja.saps.view.data.apes.service.IApesService;
import com.xdja.saps.view.data.apes.service.impl.ApesServiceImpl;
import com.xdja.saps.view.data.apes.vo.ApeListObject;
import com.xdja.saps.view.data.apes.vo.ApeObject;
import com.xdja.saps.view.data.core.enums.ResponseStatusEnum;
import com.xdja.saps.view.data.core.model.ResponseStatus;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.model.ResponseStatusListObject;
import com.xdja.saps.view.data.core.pojo.RegisteredInfo;
import com.xdja.saps.view.data.core.utils.HttpRequestUtil;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.data.report.shared.cache.RegisteredInfoCache;
import com.xdja.saps.view.repository.mapper.SuperiorPlatformMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApesServiceImpl
implements IApesService {
    private static final Logger log = LoggerFactory.getLogger(ApesServiceImpl.class);
    private final SuperiorPlatformMapper superiorPlatformMapper;
    private final SapsViewHttpClient sapsViewHttpClient;
    private final RegisteredInfoCache registeredInfoCache;

    public Object addApes(ApeListObject apeListObject, HttpServletRequest request) {
        return this.forwardApesToPlatform(apeListObject, ApesInterfaceTypeEnum.POST, request);
    }

    public Object updateDeleteApes(ApeListObject apeListObject, HttpServletRequest request) {
        return this.forwardApesToPlatform(apeListObject, ApesInterfaceTypeEnum.PUT, request);
    }

    public Object forwardApesToPlatform(ApeListObject apeListObject, ApesInterfaceTypeEnum apesInterfaceTypeEnum, HttpServletRequest request) {
        String gatewayUserIdentify = request.getHeader("User-Identify");
        if (StringUtils.isBlank((CharSequence)gatewayUserIdentify)) {
            log.error("\u8054\u7f51\u7f51\u5173\u8bf7\u6c42\u5934\u4e2d\u65e0\u8bbe\u5907\u6807\u8bc6\u4fe1\u606f");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)gatewayUserIdentify, (String)"/VIID/APEs", (String)"\u8054\u7f51\u7f51\u5173\u8bf7\u6c42\u5934\u4e2d\u65e0\u8bbe\u5907\u6807\u8bc6\u4fe1\u606f");
        }
        ApeObject apeObject = apeListObject.getApeObject();
        List apeList = apeObject.getApes();
        if (CollectionUtils.isEmpty((Collection)apeList)) {
            log.error("\u5e73\u53f0\u7aef\u6821\u9a8c\u8054\u7f51\u7f51\u5173\u8bf7\u6c42\u4e2d\u65e0\u8bbe\u5907\u4fe1\u606f");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)gatewayUserIdentify, (String)"/VIID/APEs", (String)"\u5e73\u53f0\u7aef\u6821\u9a8c\u8054\u7f51\u7f51\u5173\u8bf7\u6c42\u4e2d\u65e0\u8bbe\u5907\u4fe1\u606f");
        }
        List allRegistered = this.registeredInfoCache.getAllOnlineRegisteredInfo();
        if (CollectionUtil.isEmpty((Collection)allRegistered)) {
            log.error("\u91c7\u96c6\u8bbe\u5907\u4e0a\u62a5\uff0c\u5e73\u53f0\u7aef\u672a\u6ce8\u518c\u5230\u4e0a\u7ea7\u5e73\u53f0");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)gatewayUserIdentify, (String)"/VIID/APEs", (String)"\u5e73\u53f0\u7aef\u672a\u6ce8\u518c\u5230\u4e0a\u7ea7\u5e73\u53f0");
        }
        HashSet<String> successUrlList = new HashSet<String>();
        for (RegisteredInfo registeredInfoDto : allRegistered) {
            String url = registeredInfoDto.getSuperBaseUrl() + "/VIID/APEs";
            HttpResult httpResult = this.reqPlatform(url, registeredInfoDto, apeListObject, apesInterfaceTypeEnum);
            if (HttpStatus.OK != httpResult.getHttpStatus()) {
                log.error("\u5e73\u53f0\u7aef\u5411\u4e0a\u7ea7\u5e73\u53f0\u8f6c\u53d1\u91c7\u96c6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)url, (Object)httpResult);
                continue;
            }
            log.debug("\u8bf7\u6c42\u5730\u5740:{}\uff0c\u54cd\u5e94\u7684\u4e8c\u8fdb\u5236\u6570\u636e\u5bf9\u5e94\u768416\u8fdb\u5236\u5b57\u7b26\u4e32:{}", (Object)url, (Object)Hex.encodeHexString((byte[])httpResult.getBody()));
            String responseStr = new String(httpResult.getBody(), StandardCharsets.UTF_8);
            log.debug("\u8bf7\u6c42\u5730\u5740:{}\uff0c\u54cd\u5e94\u7684\u5b57\u7b26\u4e32:{}", (Object)url, (Object)responseStr);
            ResponseStatusListModeObject responseStatusListModeObject = (ResponseStatusListModeObject)JSON.parseObject((String)responseStr, ResponseStatusListModeObject.class);
            ResponseStatusListObject responseStatusListObject = responseStatusListModeObject.getResponseStatusListObject();
            List responseStatusList = responseStatusListObject.getResponseStatuses();
            ResponseStatus responseStatus = (ResponseStatus)responseStatusList.get(0);
            if (ResponseStatusEnum.OK.getCode().equals(responseStatus.getStatusCode())) {
                successUrlList.add(url);
                continue;
            }
            log.error("\u5e73\u53f0\u7aef\u63a5\u6536\u5230\u4e0a\u7ea7\u5e73\u53f0\u9519\u8bef\u7684\u54cd\u5e94\u6d88\u606f,\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)url, (Object)responseStatus.getStatusString());
        }
        if (successUrlList.size() > 0) {
            log.debug("\u5411\u4e0a\u7ea7\u5e73\u53f0\u8f6c\u53d1\u91c7\u96c6\u8bbe\u5907\u6570\u636e\u6210\u529f\uff0c\u6210\u529f\u7684\u4e0a\u7ea7\u5e73\u53f0\u4e2a\u6570:{}\uff0c\u6210\u529f\u7684\u4e0a\u7ea7\u5e73\u53f0\u5730\u5740:{}", (Object)successUrlList.size(), successUrlList);
            ArrayList<ResponseStatus> responseStatusList = new ArrayList<ResponseStatus>();
            responseStatusList.add(ResponseUtil.buildOkResponseStatus((String)gatewayUserIdentify, (String)"/VIID/APEs", (String)"\u6210\u529f"));
            return ResponseUtil.buildResponseStatusListModeObject(responseStatusList);
        }
        log.error("\u5e73\u53f0\u7aef\u5411\u4e0a\u7ea7\u5e73\u53f0\u8f6c\u53d1\u91c7\u96c6\u8bbe\u5907\u4fe1\u606f\u5168\u90e8\u5931\u8d25");
        return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)gatewayUserIdentify, (String)"/VIID/APEs", (String)"\u5e73\u53f0\u7aef\u5411\u4e0a\u7ea7\u5e73\u53f0\u8f6c\u53d1\u91c7\u96c6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25");
    }

    public HttpResult reqPlatform(String url, RegisteredInfo registeredInfo, ApeListObject apeListObject, ApesInterfaceTypeEnum apesInterfaceTypeEnum) {
        HttpHeaders httpHeaders = HttpRequestUtil.buildHeaders((String)registeredInfo.getDeviceId(), (String)registeredInfo.getAuth());
        String jsonString = JSON.toJSONString((Object)apeListObject);
        if (log.isDebugEnabled()) {
            log.debug("\u5e73\u53f0\u7aef\u5f00\u59cb\u8f6c\u53d1\u91c7\u96c6\u8bbe\u5907\u6570\u636e\u5230\u4e0a\u7ea7\u5e73\u53f0\uff0c\u8f6c\u53d1\u5730\u5740:{}\uff0c\u63a5\u53e3\u534f\u8bae:{}\uff0c\u8bf7\u6c42\u6570\u636e:{}", new Object[]{url, apesInterfaceTypeEnum.getDesc(), jsonString});
        }
        switch (1.$SwitchMap$com$xdja$saps$view$data$apes$enums$ApesInterfaceTypeEnum[apesInterfaceTypeEnum.ordinal()]) {
            case 1: {
                return this.sapsViewHttpClient.post(url, jsonString.getBytes(StandardCharsets.UTF_8), httpHeaders);
            }
            case 2: {
                return this.sapsViewHttpClient.put(url, jsonString.getBytes(StandardCharsets.UTF_8), httpHeaders);
            }
        }
        throw new ServiceException("\u672a\u77e5\u7684\u91c7\u96c6\u8bbe\u5907\u8f6c\u53d1\u63a5\u53e3\u7c7b\u578b");
    }

    public ApesServiceImpl(SuperiorPlatformMapper superiorPlatformMapper, SapsViewHttpClient sapsViewHttpClient, RegisteredInfoCache registeredInfoCache) {
        this.superiorPlatformMapper = superiorPlatformMapper;
        this.sapsViewHttpClient = sapsViewHttpClient;
        this.registeredInfoCache = registeredInfoCache;
    }
}

