/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.device.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.enums.IsDeleteEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.data.device.converter.DeviceConverter;
import com.xdja.saps.view.data.device.service.DeviceSyncService;
import com.xdja.saps.view.data.device.service.SuperDeviceSyncService;
import com.xdja.saps.view.data.device.vo.AddDeviceVo;
import com.xdja.saps.view.repository.dao.DeviceDao;
import com.xdja.saps.view.repository.dao.DeviceDirDao;
import com.xdja.saps.view.repository.dao.GatewayInfoDao;
import com.xdja.saps.view.repository.entity.DeviceDirEntity;
import com.xdja.saps.view.repository.entity.DeviceEntity;
import com.xdja.saps.view.repository.entity.GatewayInfoEntity;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceSyncServiceImpl
implements DeviceSyncService {
    private static final Logger log = LoggerFactory.getLogger(DeviceSyncServiceImpl.class);
    private final DeviceDirDao deviceDirDao;
    private final DeviceDao deviceDao;
    private final SuperDeviceSyncService superDeviceSyncService;
    private final GatewayInfoDao gatewayInfoDao;

    public void saveSyncDeviceStatus(List<AddDeviceVo> deviceVoList) {
        if (CollUtil.isEmpty(deviceVoList)) {
            log.error("\u540c\u6b65\u8bbe\u5907\u5931\u8d25\uff0cdeviceVoList\u4e3anull");
            return;
        }
        ArrayList<String> delDevice = new ArrayList<String>();
        ArrayList addOrUpdateDevice = new ArrayList();
        for (AddDeviceVo deviceVo : deviceVoList) {
            DeviceDirEntity deviceDirEntity = this.deviceDirDao.getDeviceDirEntityByDirCode(deviceVo.getCommunityCode());
            if (null == deviceDirEntity) {
                log.error("\u540c\u6b65\u8bbe\u5907\u5931\u8d25\uff0c\u8bbe\u5907\u6240\u5c5e\u7684\u5c0f\u533a\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u5c0f\u533a\u7f16\u7801:{}", (Object)deviceVo.getCommunityCode());
                throw new ServiceException(ErrorEnum.DIR_REGION_CODE_NOT_EXISTS_ERROR);
            }
            if (IsDeleteEnum.NORMAL_0.getValue() == IsDeleteEnum.getIsDeleteEnum((Integer)deviceVo.getIsDelete()).getValue()) {
                this.getDeviceInfo(deviceVo, addOrUpdateDevice);
            } else {
                delDevice.add(deviceVo.getCommunityCode());
            }
            this.superDeviceSyncService.forwardApesToPlatform(deviceVo);
        }
        AddDeviceVo addDeviceVo = deviceVoList.get(0);
        GatewayInfoEntity gatewayInfoEntity = this.gatewayInfoDao.getGatewayInfo(addDeviceVo.getGatewayId());
        if (null == gatewayInfoEntity) {
            log.error("\u540c\u6b65\u8bbe\u5907\u5931\u8d25\uff0c\u8bbe\u5907\u6240\u5c5e\u7f51\u5173\u4e0d\u5b58\u5728\uff0c\u7f51\u5173\u7f16\u7801:{}", (Object)addDeviceVo.getGatewayId());
            throw new ServiceException(ErrorEnum.GATEWAY_INFO_NULL_ERROR);
        }
        gatewayInfoEntity.setCommunityCode(addDeviceVo.getCommunityCode());
        this.gatewayInfoDao.updateById((Object)gatewayInfoEntity);
        this.deviceDao.deleteDevice(delDevice);
        this.deviceDao.saveOrUpdateBatch(addOrUpdateDevice);
    }

    public void getDeviceInfo(AddDeviceVo addDeviceVo, List<DeviceEntity> addOrUpdateDevice) {
        DeviceEntity deviceEntity = DeviceConverter.INSTANCE.addVoToEntity(addDeviceVo);
        DeviceEntity device = this.deviceDao.getDeviceEntityByDevCode(addDeviceVo.getDevCode());
        deviceEntity.setOnlineStatus(addDeviceVo.getIsOnline());
        if (null != device) {
            deviceEntity.setId(device.getId());
        }
        addOrUpdateDevice.add(deviceEntity);
    }

    public DeviceSyncServiceImpl(DeviceDirDao deviceDirDao, DeviceDao deviceDao, SuperDeviceSyncService superDeviceSyncService, GatewayInfoDao gatewayInfoDao) {
        this.deviceDirDao = deviceDirDao;
        this.deviceDao = deviceDao;
        this.superDeviceSyncService = superDeviceSyncService;
        this.gatewayInfoDao = gatewayInfoDao;
    }
}

