/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.device.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.xdja.saps.view.common.core.enums.IsDeleteEnum;
import com.xdja.saps.view.common.http.SapsViewHttpClient;
import com.xdja.saps.view.common.http.bean.HttpResult;
import com.xdja.saps.view.data.core.utils.HttpRequestUtil;
import com.xdja.saps.view.data.device.enums.OnlineStateEnum;
import com.xdja.saps.view.data.device.service.SuperDeviceSyncService;
import com.xdja.saps.view.data.device.vo.APEStatus;
import com.xdja.saps.view.data.device.vo.AddDeviceVo;
import com.xdja.saps.view.repository.dao.SuperiorPlatformDao;
import com.xdja.saps.view.repository.entity.SuperiorPlatformInfoEntity;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class SuperDeviceSyncServiceImpl
implements SuperDeviceSyncService {
    private static final Logger log = LoggerFactory.getLogger(SuperDeviceSyncServiceImpl.class);
    private final SuperiorPlatformDao superiorPlatformDao;
    private final SapsViewHttpClient sapsViewHttpClient;
    private static final String APES_REQ_URL = "/VIID/APEs/";

    @Async
    public void forwardApesToPlatform(AddDeviceVo addDeviceVo) {
        APEStatus apeStatus = new APEStatus();
        apeStatus.setApeID(addDeviceVo.getDevCode());
        if (IsDeleteEnum.DELETE_1.getValue() == addDeviceVo.getIsDelete().intValue()) {
            apeStatus.setIsOnline(String.valueOf(OnlineStateEnum.OFFLINE.getStatus()));
        } else {
            apeStatus.setIsOnline(String.valueOf(addDeviceVo.getIsOnline()));
        }
        apeStatus.setCurrentTime(LocalDateTime.now());
        List superiorPlatformInfoEntityList = this.superiorPlatformDao.list(null);
        if (CollUtil.isEmpty((Collection)superiorPlatformInfoEntityList)) {
            log.error("\u6ca1\u6709\u4e0a\u7ea7\u5e73\u53f0\uff0c\u4e0d\u540c\u6b65\u8bbe\u5907\u4fe1\u606f");
            return;
        }
        for (SuperiorPlatformInfoEntity platform : superiorPlatformInfoEntityList) {
            String url = "http://" + platform.getHighPlatformIp() + ":" + platform.getHighPlatformPort() + APES_REQ_URL + addDeviceVo.getDevCode() + "/IsOnline";
            HttpResult result = HttpRequestUtil.sendPost((SapsViewHttpClient)this.sapsViewHttpClient, (String)url, (String)"", (String)JSONObject.toJSONString((Object)apeStatus, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (String)platform.getUserName(), (String)platform.getPassword(), (String)platform.getDeviceCode());
            if (HttpStatus.OK == result.getHttpStatus()) continue;
            log.error("\u5411\u4e0a\u7ea7\u5e73\u53f0\u8f6c\u53d1\u8bbe\u5907\u72b6\u6001\u4fe1\u606f\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)url, (Object)result);
        }
    }

    public SuperDeviceSyncServiceImpl(SuperiorPlatformDao superiorPlatformDao, SapsViewHttpClient sapsViewHttpClient) {
        this.superiorPlatformDao = superiorPlatformDao;
        this.sapsViewHttpClient = sapsViewHttpClient;
    }
}

