/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.dir.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.xdja.saps.view.data.dir.converter.DeviceDirConverter;
import com.xdja.saps.view.data.dir.service.IDeviceDirService;
import com.xdja.saps.view.data.dir.vo.BaseDeviceDirVo;
import com.xdja.saps.view.data.dir.vo.NodeDeviceDirVo;
import com.xdja.saps.view.repository.dao.DeviceDirDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceDirServiceImpl
implements IDeviceDirService {
    private static final Logger log = LoggerFactory.getLogger(DeviceDirServiceImpl.class);
    private final DeviceDirDao deviceDirDao;

    public List<NodeDeviceDirVo> listDeviceDir() {
        List deviceDirEntities = this.deviceDirDao.list();
        List allDeviceDirNodeVoList = DeviceDirConverter.INSTANCE.entitysToNodeVos(deviceDirEntities);
        List rootDeviceDirNodeVoList = this.getRootNode(allDeviceDirNodeVoList);
        ArrayList<NodeDeviceDirVo> nodeDeviceDirVoList = new ArrayList<NodeDeviceDirVo>();
        if (CollectionUtil.isNotEmpty((Collection)rootDeviceDirNodeVoList)) {
            for (NodeDeviceDirVo deviceDirNodeVo : rootDeviceDirNodeVoList) {
                this.buildChildTree(deviceDirNodeVo, allDeviceDirNodeVoList);
                nodeDeviceDirVoList.add(deviceDirNodeVo);
            }
            nodeDeviceDirVoList.sort(Comparator.comparing(BaseDeviceDirVo::getOrderNum).thenComparing(NodeDeviceDirVo::getCreateTime).thenComparing(NodeDeviceDirVo::getId));
            return nodeDeviceDirVoList;
        }
        return null;
    }

    private NodeDeviceDirVo buildChildTree(NodeDeviceDirVo deviceDirNodeVo, List<NodeDeviceDirVo> allDeviceDirNodeVoList) {
        ArrayList<NodeDeviceDirVo> childDeviceDirList = new ArrayList<NodeDeviceDirVo>();
        for (NodeDeviceDirVo node : allDeviceDirNodeVoList) {
            if (!node.getParentId().equals(deviceDirNodeVo.getId())) continue;
            childDeviceDirList.add(this.buildChildTree(node, allDeviceDirNodeVoList));
        }
        childDeviceDirList.sort(Comparator.comparing(BaseDeviceDirVo::getOrderNum).thenComparing(NodeDeviceDirVo::getCreateTime).thenComparing(NodeDeviceDirVo::getId));
        deviceDirNodeVo.setChildren(childDeviceDirList);
        return deviceDirNodeVo;
    }

    private List<NodeDeviceDirVo> getRootNode(List<NodeDeviceDirVo> allDeviceDirNodeVoList) {
        ArrayList<NodeDeviceDirVo> rootDeviceDirList = new ArrayList<NodeDeviceDirVo>();
        for (NodeDeviceDirVo deviceDirNodeVo : allDeviceDirNodeVoList) {
            if (deviceDirNodeVo.getParentId() != 0L) continue;
            rootDeviceDirList.add(deviceDirNodeVo);
        }
        return rootDeviceDirList;
    }

    public DeviceDirServiceImpl(DeviceDirDao deviceDirDao) {
        this.deviceDirDao = deviceDirDao;
    }
}

