/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.register;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.common.core.utils.DateTimeUtil;
import com.xdja.saps.view.data.api.service.ISystemService;
import com.xdja.saps.view.data.config.SapsViewDataConfig;
import com.xdja.saps.view.data.core.model.KeepaliveObject;
import com.xdja.saps.view.data.core.model.RegisterObject;
import com.xdja.saps.view.data.core.model.ResponseStatusObject;
import com.xdja.saps.view.data.core.model.SystemTime;
import com.xdja.saps.view.data.core.model.SystemTimeObject;
import com.xdja.saps.view.data.core.model.UnRegisterObject;
import com.xdja.saps.view.data.core.utils.AuthDigestsUtil;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.repository.dao.BaseInfoDao;
import com.xdja.saps.view.repository.dao.PlatformUserDao;
import com.xdja.saps.view.repository.entity.BaseInfoEntity;
import com.xdja.saps.view.repository.entity.GatewayInfoEntity;
import com.xdja.saps.view.repository.entity.PlatformUserEntity;
import com.xdja.saps.view.repository.mapper.GatewayInfoMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SystemServiceImpl
implements ISystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    private final PlatformUserDao platformUserDao;
    private final GatewayInfoMapper gatewayInfoMapper;
    private final SapsViewDataConfig sapsViewServiceConfig;
    private final BaseInfoDao baseInfoDao;

    public ResponseStatusObject register(RegisterObject registerObject, JSONObject params) {
        String authorization = (String)params.get("authorization");
        String deviceId = registerObject.getRegister().getDeviceId();
        Result authResult = this.processAuthorization(authorization);
        if (authResult.isError()) {
            return ResponseUtil.errorOtherErrorResponseStatusObject((String)deviceId, (String)"/VIID/System/Register", (String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801\uff01");
        }
        this.saveOrUpdateRegisterInfo(deviceId);
        log.info("\u6ce8\u518c\u6210\u529f\uff1a{}", (Object)deviceId);
        return ResponseUtil.okResponseStatusObject((String)deviceId, (String)"/VIID/System/Register", (String)("\u6ce8\u518c\u6210\u529f User-Identify\uff1a" + deviceId));
    }

    public ResponseStatusObject unRegister(UnRegisterObject unRegisterObject, String authorization) {
        String deviceId = unRegisterObject.getUnRegister().getDeviceId();
        Result authResult = this.processAuthorization(authorization);
        if (authResult.isError()) {
            return ResponseUtil.errorOtherErrorResponseStatusObject((String)deviceId, (String)"/VIID/System/UnRegister", (String)"\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801\uff01");
        }
        GatewayInfoEntity gatewayInfo = this.getByDeviceId(deviceId);
        if (null == gatewayInfo) {
            log.error("\u6ce8\u9500\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u4e0d\u5b58\u5728\uff0cDeviceId\uff1a{}", (Object)deviceId);
            return ResponseUtil.errorOtherErrorResponseStatusObject((String)deviceId, (String)"/VIID/System/UnRegister", (String)"\u6ce8\u9500\u5931\u8d25");
        }
        this.gatewayInfoMapper.deleteById((Object)gatewayInfo);
        log.info("\u6ce8\u9500\u6210\u529f\uff1a{}", (Object)deviceId);
        return ResponseUtil.okResponseStatusObject((String)deviceId, (String)"/VIID/System/UnRegister", (String)("\u6ce8\u9500\u6210\u529f User-Identify\uff1a" + deviceId));
    }

    public ResponseStatusObject keepalive(KeepaliveObject keepaliveObject) {
        String deviceId = keepaliveObject.getKeepalive().getDeviceId();
        GatewayInfoEntity gatewayInfo = this.getByDeviceId(deviceId);
        if (null == gatewayInfo) {
            log.error("\u4fdd\u6d3b\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u4e0d\u5b58\u5728\uff0cDeviceId\uff1a{}", (Object)deviceId);
            return ResponseUtil.errorOtherErrorResponseStatusObject((String)deviceId, (String)"/VIID/System/Keepalive", (String)"\u4fdd\u6d3b\u5931\u8d25");
        }
        gatewayInfo.setSessionTime(LocalDateTime.now().plusMinutes(this.sapsViewServiceConfig.getSessionTime().intValue()));
        this.gatewayInfoMapper.updateById((Object)gatewayInfo);
        log.debug("\u4fdd\u6d3b\u6210\u529f\uff1a{}", (Object)deviceId);
        return ResponseUtil.okResponseStatusObject((String)deviceId, (String)"/VIID/System/Keepalive", (String)("\u4fdd\u6d3b\u6210\u529f User-Identify\uff1a" + deviceId));
    }

    public SystemTimeObject time() {
        SystemTime systemTime = new SystemTime();
        BaseInfoEntity baseInfo = (BaseInfoEntity)this.baseInfoDao.getOne(null);
        systemTime.setVIIDServerId(null == baseInfo ? "" : baseInfo.getDeviceCode());
        systemTime.setTimeMode("2");
        systemTime.setLocalTime(DateTimeUtil.getTime((DateTimeFormatter)DateTimeUtil.YYYY_MM_DD_HH_MM_SS_STAMP));
        systemTime.setTimeZon(TimeZone.getDefault().getID());
        return new SystemTimeObject(systemTime);
    }

    public String generateAuthenticate() {
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String opaque = UUID.randomUUID().toString().replace("-", "");
        return "Digest realm=\"viid\",qop=\"auth\",nonce=\"" + nonce + "\",opaque=\"" + opaque + "\"";
    }

    private Result<String> processAuthorization(String authorization) {
        String algorithm;
        String uri;
        String qop;
        String cnonce;
        String nc;
        String nonce;
        String realm;
        String responseNew;
        PlatformUserEntity platformUser;
        HashMap map = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)authorization)) {
            String temp = authorization.replaceFirst("Digest", "").trim();
            String[] split = temp.split(",");
            Arrays.asList(split).forEach(c -> {
                String c1 = c.replaceFirst("=", ":");
                String[] split1 = c1.split(":");
                map.put(split1[0].trim(), split1[1].trim().replace("\"", ""));
            });
        }
        String responseOld = String.valueOf(map.get("response"));
        String username = String.valueOf(map.get("username"));
        String password = "";
        String method = "POST";
        if (StringUtils.isNotBlank((CharSequence)username) && null != (platformUser = this.platformUserDao.getByName(username))) {
            password = platformUser.getPassword();
        }
        if (!(responseNew = AuthDigestsUtil.http_da_calc_HA1((String)username, (String)(realm = String.valueOf(map.get("realm"))), (String)password, (String)(nonce = String.valueOf(map.get("nonce"))), (String)(nc = String.valueOf(map.get("nc"))), (String)(cnonce = String.valueOf(map.get("cnonce"))), (String)(qop = String.valueOf(map.get("qop"))), (String)method, (String)(uri = String.valueOf(map.get("uri"))), (String)(algorithm = String.valueOf(map.get("algorithm"))))).equals(responseOld)) {
            return Result.fail((String)uri);
        }
        return Result.success((Object)uri);
    }

    private void saveOrUpdateRegisterInfo(String deviceId) {
        GatewayInfoEntity gatewayInfo = this.getByDeviceId(deviceId);
        if (null == gatewayInfo) {
            gatewayInfo = new GatewayInfoEntity();
            gatewayInfo.setDeviceId(deviceId);
            gatewayInfo.setSessionTime(LocalDateTime.now().plusMinutes(this.sapsViewServiceConfig.getSessionTime().intValue()));
            this.gatewayInfoMapper.insert((Object)gatewayInfo);
        } else {
            gatewayInfo.setSessionTime(LocalDateTime.now().plusMinutes(this.sapsViewServiceConfig.getSessionTime().intValue()));
            this.gatewayInfoMapper.updateById((Object)gatewayInfo);
        }
    }

    private GatewayInfoEntity getByDeviceId(String deviceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(GatewayInfoEntity::getDeviceId, (Object)deviceId);
        return (GatewayInfoEntity)this.gatewayInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    public SystemServiceImpl(PlatformUserDao platformUserDao, GatewayInfoMapper gatewayInfoMapper, SapsViewDataConfig sapsViewServiceConfig, BaseInfoDao baseInfoDao) {
        this.platformUserDao = platformUserDao;
        this.gatewayInfoMapper = gatewayInfoMapper;
        this.sapsViewServiceConfig = sapsViewServiceConfig;
        this.baseInfoDao = baseInfoDao;
    }
}

