/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.report.data.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.xdja.saps.view.common.redis.RedisKey;
import com.xdja.saps.view.common.storage.StorageService;
import com.xdja.saps.view.common.storage.enums.PathEnum;
import com.xdja.saps.view.data.api.service.IFaceService;
import com.xdja.saps.view.data.core.model.Face;
import com.xdja.saps.view.data.core.model.FaceListObject;
import com.xdja.saps.view.data.core.model.ResponseStatus;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.data.report.shared.queue.message.DataNotification;
import com.xdja.saps.view.data.report.shared.queue.message.Message;
import com.xdja.saps.view.data.report.shared.queue.message.MessageQueueUtil;
import com.xdja.saps.view.repository.dao.FaceDao;
import com.xdja.saps.view.repository.entity.FaceEntity;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FaceServiceImpl
implements IFaceService {
    private static final Logger log = LoggerFactory.getLogger(FaceServiceImpl.class);
    private final StorageService storageService;
    private final MessageQueueUtil messageQueueUtil;
    private final FaceDao faceDao;

    public ResponseStatusListModeObject batchAddFace(FaceListObject faceListObject, String userIdentify) {
        List faceList = faceListObject.getFaceObject().getFaceList();
        if (CollectionUtil.isEmpty((Collection)faceList)) {
            log.error("\u4eba\u8138\u6570\u636e\u4e3a\u7a7a");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)userIdentify, (String)"/VIID/Faces", (String)"\u6570\u636e\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u4eba\u8138\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)faceListObject, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        ArrayList<ResponseStatus> responseStatusList = new ArrayList<ResponseStatus>();
        Iterator iterator = faceList.iterator();
        while (iterator.hasNext()) {
            Face face = (Face)iterator.next();
            FaceEntity faceEntity = (FaceEntity)this.faceDao.getById((Serializable)((Object)face.getFaceId()));
            if (null != faceEntity) {
                iterator.remove();
                responseStatusList.add(ResponseUtil.buildOtherErrorResponseStatus((String)face.getFaceId(), (String)"/VIID/Faces", (String)("\u4eba\u8138\u6570\u636e\uff1a" + face.getFaceId() + "\uff0c\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55")));
                continue;
            }
            responseStatusList.add(ResponseUtil.buildOkResponseStatus((String)face.getFaceId(), (String)"/VIID/Faces", (String)"\u6210\u529f"));
        }
        this.uploadAndPublish(faceList, userIdentify);
        return ResponseUtil.buildResponseStatusListModeObject(responseStatusList);
    }

    private void uploadAndPublish(List<Face> faceList, String userIdentify) {
        ArrayList msgList = new ArrayList();
        faceList.forEach(face -> {
            String faceId = face.getFaceId();
            String basePath = PathEnum.FACE.getPath() + faceId;
            ArrayList imagePathList = new ArrayList();
            List subImageInfos = face.getSubImageList().getSubImageInfos();
            subImageInfos.forEach(subImageInfo -> {
                if (StrUtil.isNotBlank((CharSequence)subImageInfo.getData())) {
                    byte[] bytes = Base64.decodeBase64((String)subImageInfo.getData());
                    if (null == bytes || bytes.length == 0) {
                        return;
                    }
                    subImageInfo.setData("");
                    String imageId = subImageInfo.getImageId();
                    String uploadPath = this.storageService.upload(basePath + "/" + imageId, imageId + "." + subImageInfo.getFileFormat(), bytes);
                    imagePathList.add(uploadPath);
                }
            });
            String jsonPath = this.storageService.upload(basePath, faceId + ".json", JSON.toJSONBytes((Object)face));
            DataNotification dataNotification = new DataNotification();
            dataNotification.setGatewayId(userIdentify);
            dataNotification.setDevCode(face.getDeviceId());
            dataNotification.setJsonPath(jsonPath);
            dataNotification.setReportDateTime(LocalDateTime.now());
            dataNotification.setDataPathList(imagePathList);
            msgList.add(dataNotification);
        });
        this.messageQueueUtil.sendMsg(RedisKey.QUEUE_FACE.getKey(), new Message(msgList));
    }

    public FaceServiceImpl(StorageService storageService, MessageQueueUtil messageQueueUtil, FaceDao faceDao) {
        this.storageService = storageService;
        this.messageQueueUtil = messageQueueUtil;
        this.faceDao = faceDao;
    }
}

