/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.report.data.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.xdja.saps.view.common.redis.RedisKey;
import com.xdja.saps.view.common.storage.StorageService;
import com.xdja.saps.view.common.storage.enums.PathEnum;
import com.xdja.saps.view.data.api.service.ImagesService;
import com.xdja.saps.view.data.core.model.ImageInfo;
import com.xdja.saps.view.data.core.model.ImageListObject;
import com.xdja.saps.view.data.core.model.ImageObject;
import com.xdja.saps.view.data.core.model.ResponseStatus;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.model.ResponseStatusObject;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.data.report.shared.queue.message.DataNotification;
import com.xdja.saps.view.data.report.shared.queue.message.Message;
import com.xdja.saps.view.data.report.shared.queue.message.MessageQueueUtil;
import com.xdja.saps.view.repository.dao.ImageInfoDao;
import com.xdja.saps.view.repository.entity.ImageInfoEntity;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImagesServiceImpl
implements ImagesService {
    private static final Logger log = LoggerFactory.getLogger(ImagesServiceImpl.class);
    private final StorageService storageService;
    private final MessageQueueUtil messageQueueUtil;
    private final ImageInfoDao imageInfoDao;

    public ResponseStatusListModeObject batchAddImages(ImageListObject imageListObject, String userIdentify) {
        List imageObjectList = imageListObject.getImageListObject().getImageObjectList();
        if (CollUtil.isEmpty((Collection)imageObjectList)) {
            log.error("\u56fe\u50cf\u6279\u91cf\u589e\u52a0\u65f6\u6570\u636e\u4e3a\u7a7a");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)userIdentify, (String)"/VIID/Images", (String)"\u56fe\u50cf\u6570\u636e\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u56fe\u50cf\u6279\u91cf\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)imageListObject));
        }
        ArrayList<ResponseStatus> responseStatusList = new ArrayList<ResponseStatus>();
        Iterator iterator = imageObjectList.iterator();
        while (iterator.hasNext()) {
            ImageObject imageObject = (ImageObject)iterator.next();
            ImageInfo imageInfo = imageObject.getImageInfo();
            ImageInfoEntity imageInfoEntity = (ImageInfoEntity)this.imageInfoDao.getById((Serializable)((Object)imageInfo.getImageId()));
            if (null != imageInfoEntity) {
                iterator.remove();
                responseStatusList.add(ResponseUtil.buildOtherErrorResponseStatus((String)imageInfo.getImageId(), (String)"/VIID/Images", (String)("\u56fe\u50cf\u6570\u636e\uff1a" + imageInfo.getImageId() + "\uff0c\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55")));
                continue;
            }
            responseStatusList.add(ResponseUtil.buildOkResponseStatus((String)imageInfo.getImageId(), (String)"/VIID/Images", (String)"\u6210\u529f"));
        }
        this.uploadAndPublish(imageObjectList, userIdentify);
        return ResponseUtil.buildResponseStatusListModeObject(responseStatusList);
    }

    public ResponseStatusObject addImages(String base64, String userIdentify, String id) {
        if (base64 == null || "".equalsIgnoreCase(base64)) {
            log.error("\u56fe\u50cf\u589e\u52a0\u65f6\u6570\u636e\u4e3a\u7a7a");
            return ResponseUtil.errorOtherErrorResponseStatusObject((String)userIdentify, (String)"/VIID/Images/{ID}/Data", (String)("\u56fe\u50cf\u6570\u636e\u4e3a\u7a7a" + id));
        }
        if (log.isDebugEnabled()) {
            log.debug("\u56fe\u50cf\u6570\u636e\uff1a{}", (Object)base64);
        }
        return ResponseUtil.errorOtherErrorResponseStatusObject((String)userIdentify, (String)"/VIID/Images/{ID}/Data", (String)("\u6210\u529f" + id));
    }

    private void uploadAndPublish(List<ImageObject> imageObjectList, String userIdentify) {
        ArrayList msgList = new ArrayList();
        imageObjectList.forEach(imageObject -> {
            ImageInfo imageInfo = imageObject.getImageInfo();
            String imageId = imageInfo.getImageId();
            String basePath = PathEnum.IMAGE.getPath() + imageId;
            String data = imageObject.getData();
            String imagePath = "";
            if (StrUtil.isNotBlank((CharSequence)data)) {
                byte[] bytes = Base64.decodeBase64((String)data);
                imagePath = this.storageService.upload(basePath, imageId + "." + imageInfo.getFileFormat(), bytes);
            }
            String jsonPath = this.storageService.upload(basePath, imageId + ".json", JSON.toJSONBytes((Object)imageInfo));
            DataNotification dataNotification = new DataNotification();
            dataNotification.setGatewayId(userIdentify);
            dataNotification.setDevCode(imageInfo.getDeviceId());
            dataNotification.setReportDateTime(LocalDateTime.now());
            dataNotification.setJsonPath(jsonPath);
            dataNotification.setDataPathList(StrUtil.isBlank((CharSequence)imagePath) ? null : CollectionUtil.toList((Object[])new String[]{imagePath}));
            msgList.add(dataNotification);
        });
        this.messageQueueUtil.sendMsg(RedisKey.QUEUE_IMAGE.getKey(), new Message(msgList));
    }

    public ImagesServiceImpl(StorageService storageService, MessageQueueUtil messageQueueUtil, ImageInfoDao imageInfoDao) {
        this.storageService = storageService;
        this.messageQueueUtil = messageQueueUtil;
        this.imageInfoDao = imageInfoDao;
    }
}

