/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.report.data.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSON;
import com.xdja.saps.view.common.redis.RedisKey;
import com.xdja.saps.view.common.storage.StorageService;
import com.xdja.saps.view.common.storage.enums.PathEnum;
import com.xdja.saps.view.data.api.service.MotorVehicleService;
import com.xdja.saps.view.data.core.model.MotorVehicle;
import com.xdja.saps.view.data.core.model.MotorVehicleListObject;
import com.xdja.saps.view.data.core.model.ResponseStatus;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.data.report.shared.queue.message.DataNotification;
import com.xdja.saps.view.data.report.shared.queue.message.Message;
import com.xdja.saps.view.data.report.shared.queue.message.MessageQueueUtil;
import com.xdja.saps.view.repository.dao.MotorVehicleDao;
import com.xdja.saps.view.repository.entity.MotorVehicleEntity;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MotorVehicleServiceImpl
implements MotorVehicleService {
    private static final Logger log = LoggerFactory.getLogger(MotorVehicleServiceImpl.class);
    private final MotorVehicleDao motorVehicleDao;
    private final StorageService storageService;
    private final MessageQueueUtil messageQueueUtil;

    public ResponseStatusListModeObject addMotorVehicleBatch(MotorVehicleListObject req, String userIdentify) {
        List motorVehicleList = req.getMotorVehicleObject().getMotorVehicles();
        if (CollUtil.isEmpty((Collection)motorVehicleList)) {
            log.error("\u673a\u52a8\u8f66\u6279\u91cf\u589e\u52a0\u65f6\u6570\u636e\u4e3a\u7a7a");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)userIdentify, (String)"/VIID/MotorVehicles", (String)"\u673a\u52a8\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u673a\u52a8\u8f66\u6279\u91cf\u6570\u636e\uff1a{}", (Object)req);
        }
        ArrayList<ResponseStatus> responseStatusList = new ArrayList<ResponseStatus>();
        Iterator iterator = motorVehicleList.iterator();
        while (iterator.hasNext()) {
            MotorVehicle motorVehicle = (MotorVehicle)iterator.next();
            MotorVehicleEntity motorVehicleEntity = (MotorVehicleEntity)this.motorVehicleDao.getById((Serializable)((Object)motorVehicle.getMotorVehicleId()));
            if (null != motorVehicleEntity) {
                iterator.remove();
                responseStatusList.add(ResponseUtil.buildOtherErrorResponseStatus((String)motorVehicle.getMotorVehicleId(), (String)"/VIID/MotorVehicles", (String)("\u673a\u52a8\u8f66\u6570\u636e\uff1a" + motorVehicle.getMotorVehicleId() + "\uff0c\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55")));
                continue;
            }
            responseStatusList.add(ResponseUtil.buildOkResponseStatus((String)motorVehicle.getMotorVehicleId(), (String)"/VIID/MotorVehicles", (String)"\u6210\u529f"));
        }
        this.uploadAndPublish(motorVehicleList, userIdentify);
        return ResponseUtil.buildResponseStatusListModeObject(responseStatusList);
    }

    private void uploadAndPublish(List<MotorVehicle> motorVehicleList, String userIdentify) {
        ArrayList msgList = new ArrayList();
        motorVehicleList.forEach(motorVehicle -> {
            String motorVehicleId = motorVehicle.getMotorVehicleId();
            String basePath = PathEnum.MOTOR_VEHICLE.getPath() + motorVehicleId;
            ArrayList imagePathList = new ArrayList();
            List subImageInfos = motorVehicle.getSubImageList().getSubImageInfos();
            subImageInfos.forEach(subImageInfo -> {
                if (StringUtils.isNotBlank((CharSequence)subImageInfo.getData())) {
                    byte[] bytes = Base64.decodeBase64((String)subImageInfo.getData());
                    if (null == bytes || bytes.length == 0) {
                        return;
                    }
                    subImageInfo.setData("");
                    String imageId = subImageInfo.getImageId();
                    String uploadPath = this.storageService.upload(basePath + "/" + imageId, imageId + "." + subImageInfo.getFileFormat(), bytes);
                    imagePathList.add(uploadPath);
                }
            });
            String jsonPath = this.storageService.upload(basePath, motorVehicleId + ".json", JSON.toJSONBytes((Object)motorVehicle));
            DataNotification dataNotification = new DataNotification();
            dataNotification.setGatewayId(userIdentify);
            dataNotification.setDevCode(motorVehicle.getDeviceId());
            dataNotification.setJsonPath(jsonPath);
            dataNotification.setReportDateTime(LocalDateTime.now());
            dataNotification.setDataPathList(imagePathList);
            msgList.add(dataNotification);
        });
        this.messageQueueUtil.sendMsg(RedisKey.QUEUE_MOTOR_VEHICLE.getKey(), new Message(msgList));
    }

    public MotorVehicleServiceImpl(MotorVehicleDao motorVehicleDao, StorageService storageService, MessageQueueUtil messageQueueUtil) {
        this.motorVehicleDao = motorVehicleDao;
        this.storageService = storageService;
        this.messageQueueUtil = messageQueueUtil;
    }
}

