/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.report.data.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSON;
import com.xdja.saps.view.common.redis.RedisKey;
import com.xdja.saps.view.common.storage.StorageService;
import com.xdja.saps.view.common.storage.enums.PathEnum;
import com.xdja.saps.view.data.api.service.VideoSlicesService;
import com.xdja.saps.view.data.core.model.ResponseStatus;
import com.xdja.saps.view.data.core.model.ResponseStatusListModeObject;
import com.xdja.saps.view.data.core.model.VideoSliceInfo;
import com.xdja.saps.view.data.core.model.VideoSliceListObject;
import com.xdja.saps.view.data.core.model.VideoSliceObject;
import com.xdja.saps.view.data.core.utils.ResponseUtil;
import com.xdja.saps.view.data.report.shared.queue.message.DataNotification;
import com.xdja.saps.view.data.report.shared.queue.message.Message;
import com.xdja.saps.view.data.report.shared.queue.message.MessageQueueUtil;
import com.xdja.saps.view.repository.dao.VideoSliceDao;
import com.xdja.saps.view.repository.entity.VideoSliceInfoEntity;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VideoSliceServiceImpl
implements VideoSlicesService {
    private static final Logger log = LoggerFactory.getLogger(VideoSliceServiceImpl.class);
    private final VideoSliceDao videoSliceDao;
    private final MessageQueueUtil messageQueueUtil;
    private final StorageService storageService;

    public ResponseStatusListModeObject batchAddVideoSlices(VideoSliceListObject req, String userIdentify) {
        List videoSliceObjects = req.getVideoSliceListObject().getVideoSliceObjectList();
        if (CollUtil.isEmpty((Collection)videoSliceObjects)) {
            log.error("\u89c6\u9891\u7247\u6bb5\u6279\u91cf\u589e\u52a0\u65f6\u6570\u636e\u4e3a\u7a7a");
            return ResponseUtil.errorOtherErrorResponseStatusListModeObject((String)userIdentify, (String)"/VIID/VideoSlices", (String)"\u89c6\u9891\u7247\u6bb5\u6570\u636e\u4e3a\u7a7a");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u89c6\u9891\u7247\u6bb5\u6279\u91cf\u6570\u636e\uff1a{}", (Object)req);
        }
        ArrayList<ResponseStatus> responseStatusList = new ArrayList<ResponseStatus>();
        Iterator iterator = videoSliceObjects.iterator();
        while (iterator.hasNext()) {
            VideoSliceObject videoSliceObject = (VideoSliceObject)iterator.next();
            VideoSliceInfo videoSliceInfo = videoSliceObject.getVideoSliceInfo();
            VideoSliceInfoEntity videoSliceInfoEntity = (VideoSliceInfoEntity)this.videoSliceDao.getById((Serializable)((Object)videoSliceInfo.getVideoId()));
            if (null != videoSliceInfoEntity) {
                iterator.remove();
                responseStatusList.add(ResponseUtil.buildOtherErrorResponseStatus((String)videoSliceInfo.getVideoId(), (String)"/VIID/VideoSlices", (String)("\u89c6\u9891\u6570\u636e\uff1a" + videoSliceInfo.getVideoId() + "\uff0c\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55")));
                continue;
            }
            responseStatusList.add(ResponseUtil.buildOkResponseStatus((String)videoSliceInfo.getVideoId(), (String)"/VIID/VideoSlices", (String)"\u6210\u529f"));
        }
        this.uploadAndPublish(videoSliceObjects, userIdentify);
        return ResponseUtil.buildResponseStatusListModeObject(responseStatusList);
    }

    private void uploadAndPublish(List<VideoSliceObject> videoSliceObjectList, String userIdentify) {
        ArrayList msgList = new ArrayList();
        videoSliceObjectList.forEach(videoSliceObject -> {
            VideoSliceInfo videoSliceInfo = videoSliceObject.getVideoSliceInfo();
            String videoId = videoSliceInfo.getVideoId();
            String basePath = PathEnum.MOTOR_VIDEOSLICE.getPath() + videoId;
            String data = videoSliceObject.getData();
            String uploadPath = "";
            if (StringUtils.isNotBlank((CharSequence)data)) {
                uploadPath = this.storageService.upload(basePath, videoId + ".base64", data.getBytes());
            }
            String jsonPath = this.storageService.upload(basePath, videoId + ".json", JSON.toJSONBytes((Object)videoSliceInfo));
            DataNotification dataNotification = new DataNotification();
            dataNotification.setGatewayId(userIdentify);
            dataNotification.setDevCode(videoSliceInfo.getDeviceId());
            dataNotification.setJsonPath(jsonPath);
            dataNotification.setReportDateTime(LocalDateTime.now());
            dataNotification.setDataPathList(StringUtils.isBlank((CharSequence)uploadPath) ? null : CollUtil.toList((Object[])new String[]{uploadPath}));
            msgList.add(dataNotification);
        });
        this.messageQueueUtil.sendMsg(RedisKey.QUEUE_VIDEO_SLICE.getKey(), new Message(msgList));
    }

    public VideoSliceServiceImpl(VideoSliceDao videoSliceDao, MessageQueueUtil messageQueueUtil, StorageService storageService) {
        this.videoSliceDao = videoSliceDao;
        this.messageQueueUtil = messageQueueUtil;
        this.storageService = storageService;
    }
}

