/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.data.report.security.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.xdja.saps.mmc.service.IMmcService;
import com.xdja.saps.mmc.service.bean.ViewData;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.common.http.SapsViewHttpClient;
import com.xdja.saps.view.common.http.bean.HttpResult;
import com.xdja.saps.view.data.config.SapsViewDataConfig;
import com.xdja.saps.view.data.report.security.service.ISecurityService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class SecurityServiceImpl
implements ISecurityService {
    private static final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private final SapsViewDataConfig sapsViewDataConfig;
    private final DiscoveryClient discoveryClient;
    private final SapsViewHttpClient sapsViewHttpClient;
    private final IMmcService mmcService;

    public Object processSecurityData(JSONObject jsonObject, HttpServletResponse response) {
        List list;
        if (log.isDebugEnabled()) {
            log.debug("\u5bc6\u6587\u6570\u636e\uff1a{}", (Object)jsonObject);
        }
        if (CollectionUtil.isEmpty((Collection)(list = this.mmcService.decryptViewData(jsonObject.toJSONString(new JSONWriter.Feature[0]))))) {
            log.error("\u89e3\u5bc6\u540e\u6570\u636e\u4e3a\u7a7a");
            throw new ServiceException(ErrorEnum.DATA_DECRYPT_ERROR);
        }
        ViewData viewData = (ViewData)list.get(0);
        String url = viewData.getOriginURI();
        String body = viewData.getBody();
        if (log.isDebugEnabled()) {
            log.debug("\u660e\u6587\u6570\u636e\uff1a{}", (Object)body);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/VIID+JSON;charset=UTF-8");
        List instances = this.discoveryClient.getInstances(this.sapsViewDataConfig.getApplicationName());
        if (CollectionUtil.isEmpty((Collection)instances)) {
            log.error("\u672a\u5728Nacos\u4e2d\u627e\u5230\u53ef\u7528\u7684view-data\u670d\u52a1");
            throw new ServiceException(ErrorEnum.SERVER_INTERNAL_EXCEPTION);
        }
        ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
        String fullUrl = "http://" + serviceInstance.getHost() + ":" + serviceInstance.getPort() + url;
        HttpResult httpResult = this.sapsViewHttpClient.post(fullUrl, body.getBytes(), headers);
        log.debug("\u8f6c\u53d1\u7ed3\u679c\uff1a{}", (Object)httpResult);
        response.setStatus(httpResult.getStatusCode());
        HttpHeaders responseHeaders = httpResult.getHeaders();
        if (null != responseHeaders) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String value : values) {
                    response.setHeader(key, value);
                }
            }
        }
        return httpResult.getStrBody();
    }

    public SecurityServiceImpl(SapsViewDataConfig sapsViewDataConfig, DiscoveryClient discoveryClient, SapsViewHttpClient sapsViewHttpClient, IMmcService mmcService) {
        this.sapsViewDataConfig = sapsViewDataConfig;
        this.discoveryClient = discoveryClient;
        this.sapsViewHttpClient = sapsViewHttpClient;
        this.mmcService = mmcService;
    }
}

