/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.filter;

import com.xdja.saps.view.system.auth.service.IAuthService;
import com.xdja.saps.view.system.auth.utils.SessionUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Deque;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KickOutSessionFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(KickOutSessionFilter.class);
    private Cache<String, Deque<Serializable>> cache;
    private final boolean kickoutAfter = false;
    private final SessionManager sessionManager;
    private final IAuthService authService;

    public KickOutSessionFilter(CacheManager cacheManager, SessionManager sessionManager, IAuthService authService) {
        this.cache = cacheManager.getCache("shiro-kickout-session");
        this.sessionManager = sessionManager;
        this.authService = authService;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (!subject.isAuthenticated() && !subject.isRemembered()) {
            return true;
        }
        SessionUtils.saveAndKickoutSession((Cache)this.cache, (boolean)false, (SessionManager)this.sessionManager, (Subject)subject);
        Session session = subject.getSession();
        if (session.getAttribute((Object)"kickout") != null) {
            subject.logout();
            this.redirectUrl(request, response);
            return false;
        }
        return true;
    }

    private void redirectUrl(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.setHeader("sessionstatus", "timeout");
        resp.setStatus(401);
        resp.setContentType("application/json;charset=UTF-8");
        resp.setHeader("Pragma", "No-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(this.authService.unAuthenticationContent());
        }
        catch (IOException e) {
            log.error(String.format("Shiro\u81ea\u5b9a\u4e49\u6743\u9650\u8fc7\u6ee4\u5668\u54cd\u5e94Ajax\u8bf7\u6c42\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
        }
    }
}

