/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.xdja.saps.view.common.core.bean.ErrorBean;
import com.xdja.saps.view.system.auth.bean.Function;
import com.xdja.saps.view.system.auth.service.IAuthService;
import com.xdja.saps.view.system.user.entity.FunctionEntity;
import com.xdja.saps.view.system.user.mapper.FunctionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements IAuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final FunctionMapper functionMapper;

    public Collection<Function> getFunctions() {
        List functionEntities = this.functionMapper.selectList(null);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (FunctionEntity functionEntity : functionEntities) {
            Function function = new Function();
            function.setApi(functionEntity.getFunctionApi());
            function.setPermission(functionEntity.getFunctionKey());
            functions.add(function);
        }
        return functions;
    }

    public List<String> getPermissionByUserName(String userName) {
        List functionList = this.functionMapper.selectFunctionByLoginName(userName);
        ArrayList<String> list = new ArrayList<String>();
        for (String function : functionList) {
            if (list.contains(function)) continue;
            list.add(function);
        }
        return list;
    }

    public Collection<String> getWhiteLink() {
        ArrayList<String> whiteLinks = new ArrayList<String>();
        whiteLinks.add("/v1/sys/account/login");
        whiteLinks.add("/v1/sys/account/logout");
        whiteLinks.add("/v1/devicedir");
        return whiteLinks;
    }

    public String unAuthenticationContent() {
        try {
            return JSON.toJSONString((Object)new ErrorBean(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), "\u8eab\u4efd\u672a\u8ba4\u8bc1"));
        }
        catch (JSONException e) {
            log.error("\u81ea\u5b9a\u6743\u9650\u6821\u9a8c\u65f6\uff0c\u672a\u767b\u5f55\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return "{\"errCode\":10005,\"errMsg\":\"unauthenticated\"}";
        }
    }

    public String unAuthorizationContent() {
        try {
            return JSON.toJSONString((Object)new ErrorBean(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), "\u672a\u6388\u6743\u7684\u8bf7\u6c42"));
        }
        catch (JSONException e) {
            log.error("\u81ea\u5b9a\u6743\u9650\u6821\u9a8c\u65f6\uff0c\u672a\u6388\u6743\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return "{\"errCode\":10004,\"errMsg\":\"unauthorized_request\"}";
        }
    }

    public AuthServiceImpl(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }
}

