/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.utils;

import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger log = LoggerFactory.getLogger(SessionUtils.class);

    public static void saveAndKickoutSession(Cache<String, Deque<Serializable>> cache, boolean kickoutAfter, SessionManager sessionManager, Subject subject) {
        Session session = subject.getSession();
        String username = (String)subject.getPrincipal();
        Serializable sessionId = session.getId();
        LinkedList<Serializable> deque = (LinkedList<Serializable>)cache.get((Object)username);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
            cache.put((Object)username, deque);
        }
        if (!deque.contains(sessionId) && null == session.getAttribute((Object)"kickout")) {
            deque.push(sessionId);
        }
        while (deque.size() > 1) {
            Serializable kickoutSessionId = null;
            kickoutSessionId = kickoutAfter ? (Serializable)deque.removeFirst() : (Serializable)deque.removeLast();
            try {
                Session kickoutSession = sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                if (null == kickoutSession) continue;
                kickoutSession.setAttribute((Object)"kickout", (Object)true);
            }
            catch (Exception e) {
                log.debug("no session id {}", (Object)kickoutSessionId);
            }
        }
    }

    public static void removeCacheSession(String username, Serializable sessionId, Cache<String, Deque<Serializable>> cache) {
        Deque deque = (Deque)cache.get((Object)username);
        deque.remove(sessionId);
        if (deque.isEmpty()) {
            cache.remove((Object)username);
        }
    }
}

