/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.device.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xdja.saps.view.common.core.bean.PageInfo;
import com.xdja.saps.view.system.device.converter.DeviceConverter;
import com.xdja.saps.view.system.device.entity.DeviceEntity;
import com.xdja.saps.view.system.device.enums.OnlineStateEnum;
import com.xdja.saps.view.system.device.mapper.DeviceMapper;
import com.xdja.saps.view.system.device.repository.IDeviceRepository;
import com.xdja.saps.view.system.device.vo.ListDeviceVo;
import com.xdja.saps.view.system.device.vo.QueryDeviceVo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceRepositoryImpl
extends ServiceImpl<DeviceMapper, DeviceEntity>
implements IDeviceRepository {
    private static final Logger log = LoggerFactory.getLogger(DeviceRepositoryImpl.class);

    public PageInfo getDeviceDirVoList(QueryDeviceVo queryDeviceDirVo, Integer pageNo, Integer pageSize) {
        IPage iPage;
        Page pagetable = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isBlank((CharSequence)queryDeviceDirVo.getDirCode())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)queryDeviceDirVo.getDevName())) {
                queryWrapper.like((Object)"dev_name", (Object)queryDeviceDirVo.getDevName());
            }
            ((QueryWrapper)queryWrapper.orderByDesc((Object)"create_time")).orderByDesc((Object)"id");
            iPage = ((DeviceMapper)this.baseMapper).selectPage((IPage)pagetable, (Wrapper)queryWrapper);
        } else {
            iPage = ((DeviceMapper)this.baseMapper).getDeviceDirVoListByDirCode((IPage)pagetable, queryDeviceDirVo);
        }
        List deviceVoList = DeviceConverter.INSTANCE.entitysToVos(iPage.getRecords());
        if (CollectionUtil.isNotEmpty((Collection)deviceVoList)) {
            for (ListDeviceVo listDeviceVo : deviceVoList) {
                OnlineStateEnum onlineStateEnum = listDeviceVo.getSessionTime().isBefore(LocalDateTime.now()) ? OnlineStateEnum.OFFLINE : OnlineStateEnum.ONLINE;
                listDeviceVo.setOnlineStatus(Integer.valueOf(onlineStateEnum.getStatus()));
            }
        }
        return new PageInfo(iPage.getPages(), iPage.getTotal(), (Collection)deviceVoList);
    }

    public long countDeviceEntityByDevCode(String devCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DeviceEntity::getDevCode, (Object)devCode);
        return this.count((Wrapper)lambdaQueryWrapper);
    }
}

