/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.device.service.impl;

import com.xdja.saps.view.common.core.bean.PageInfo;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.system.device.converter.DeviceConverter;
import com.xdja.saps.view.system.device.entity.DeviceEntity;
import com.xdja.saps.view.system.device.entity.DeviceInfoDirEntity;
import com.xdja.saps.view.system.device.repository.IDeviceInfoDirRepository;
import com.xdja.saps.view.system.device.repository.IDeviceRepository;
import com.xdja.saps.view.system.device.service.IDeviceService;
import com.xdja.saps.view.system.device.vo.AddDeviceVo;
import com.xdja.saps.view.system.device.vo.QueryDeviceVo;
import com.xdja.saps.view.system.dir.entity.DeviceDirEntity;
import com.xdja.saps.view.system.dir.repository.IDeviceDirRepository;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceServiceImpl
implements IDeviceService {
    private static final Logger log = LoggerFactory.getLogger(DeviceServiceImpl.class);
    private final IDeviceRepository deviceRepository;
    private final IDeviceDirRepository deviceDirRepository;
    private final IDeviceInfoDirRepository iDeviceInfoDirRepository;

    public PageInfo getDeviceDirVoList(QueryDeviceVo queryDeviceDirVo, Integer pageNo, Integer pageSize) {
        if (null == queryDeviceDirVo) {
            throw new ServiceException("\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.deviceRepository.getDeviceDirVoList(queryDeviceDirVo, pageNo, pageSize);
    }

    public void saveDeviceInfo(AddDeviceVo addDeviceVo) {
        DeviceDirEntity entity;
        if (null == addDeviceVo || null == addDeviceVo.getDevCode()) {
            log.error("\u8bbe\u5907\u5bf9\u8c61\u4e3a\u7a7a");
            throw new ServiceException(ErrorEnum.DEVICE_IS_NULL);
        }
        long countDevice = this.deviceRepository.countDeviceEntityByDevCode(addDeviceVo.getDevCode());
        if (countDevice > 0L) {
            log.error("\u8bbe\u5907\u5df2\u5b58\u5728\uff0c\u8bbe\u5907\u7f16\u7801:{}", (Object)addDeviceVo.getDevCode());
            throw new ServiceException(ErrorEnum.DEVICE_EXISTS);
        }
        DeviceEntity deviceEntity = DeviceConverter.INSTANCE.addVoToEntity(addDeviceVo);
        this.deviceRepository.save((Object)deviceEntity);
        DeviceDirEntity deviceDirEntity = this.deviceDirRepository.getDeviceDirEntityByDirCode(addDeviceVo.getDirCode());
        if (null == deviceDirEntity) {
            log.error("\u8bbe\u5907\u6240\u5c5e\u7684\u5c0f\u533a\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u5c0f\u533a\u7f16\u7801:{}", (Object)addDeviceVo.getDirCode());
            throw new ServiceException(ErrorEnum.DIR_REGION_CODE_NOT_EXISTS_ERROR);
        }
        Long deviceInfoId = deviceEntity.getId();
        ArrayList<DeviceInfoDirEntity> deviceInfoDirEntityList = new ArrayList<DeviceInfoDirEntity>();
        DeviceInfoDirEntity deviceInfoDirEntity = new DeviceInfoDirEntity();
        deviceInfoDirEntity.setDeviceInfoId(deviceInfoId);
        deviceInfoDirEntity.setDirCode(deviceDirEntity.getDirCode());
        deviceInfoDirEntityList.add(deviceInfoDirEntity);
        Long parentId = deviceDirEntity.getParentId();
        while (null != (entity = (DeviceDirEntity)this.deviceDirRepository.getById((Serializable)parentId))) {
            deviceInfoDirEntity = new DeviceInfoDirEntity();
            deviceInfoDirEntity.setDeviceInfoId(deviceInfoId);
            deviceInfoDirEntity.setDirCode(entity.getDirCode());
            parentId = entity.getParentId();
            deviceInfoDirEntityList.add(deviceInfoDirEntity);
        }
        this.iDeviceInfoDirRepository.saveBatch(deviceInfoDirEntityList);
    }

    public DeviceServiceImpl(IDeviceRepository deviceRepository, IDeviceDirRepository deviceDirRepository, IDeviceInfoDirRepository iDeviceInfoDirRepository) {
        this.deviceRepository = deviceRepository;
        this.deviceDirRepository = deviceDirRepository;
        this.iDeviceInfoDirRepository = iDeviceInfoDirRepository;
    }
}

