/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.dir.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.system.device.mapper.DeviceMapper;
import com.xdja.saps.view.system.dir.bean.ParentDeviceDirBean;
import com.xdja.saps.view.system.dir.converter.DeviceDirConverter;
import com.xdja.saps.view.system.dir.entity.DeviceDirEntity;
import com.xdja.saps.view.system.dir.enums.ExpandStateEnum;
import com.xdja.saps.view.system.dir.repository.IDeviceDirRepository;
import com.xdja.saps.view.system.dir.service.IDeviceDirService;
import com.xdja.saps.view.system.dir.utils.ReadExcelUtils;
import com.xdja.saps.view.system.dir.vo.AddDeviceDirVo;
import com.xdja.saps.view.system.dir.vo.BaseDeviceDirVo;
import com.xdja.saps.view.system.dir.vo.DetailsDeviceDirVo;
import com.xdja.saps.view.system.dir.vo.NodeDeviceDirVo;
import com.xdja.saps.view.system.dir.vo.UpdateDeviceDirVo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DeviceDirServiceImpl
implements IDeviceDirService {
    private static final Logger log = LoggerFactory.getLogger(DeviceDirServiceImpl.class);
    private final IDeviceDirRepository deviceDirRepository;
    private final DeviceMapper deviceMapper;
    public static final int TREE_REGION_LEVEL = 4;

    public void insertDeviceDir(AddDeviceDirVo addDeviceDirVo) {
        DeviceDirEntity dirEntity = (DeviceDirEntity)this.deviceDirRepository.getById((Serializable)addDeviceDirVo.getParentId());
        if (null != dirEntity && dirEntity.getLevel() >= 6) {
            log.error("\u6700\u5927\u652f\u6301{}\u4e2a\u5c42\u7ea7\uff0c\u65e0\u6cd5\u6dfb\u52a0\u65b0\u7684\u76ee\u5f55", (Object)6);
            throw new ServiceException(ErrorEnum.DIR_TREE_EXCEED_LIMIT_ERROR);
        }
        DeviceDirEntity entity = this.deviceDirRepository.getDeviceDirEntityByDirCode(addDeviceDirVo.getDirCode());
        if (null != entity) {
            log.error("\u65b0\u589e\u7684\u76ee\u5f55\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u76ee\u5f55\u7f16\u7801:{}", (Object)addDeviceDirVo.getDirCode());
            throw new ServiceException(ErrorEnum.DIR_CODE_EXISTS_ERROR);
        }
        DeviceDirEntity deviceDirEntity = DeviceDirConverter.INSTANCE.addVoToEntity(addDeviceDirVo);
        int level = null == dirEntity ? 1 : dirEntity.getLevel() + 1;
        deviceDirEntity.setLevel(Integer.valueOf(level));
        this.deviceDirRepository.save((Object)deviceDirEntity);
    }

    public void updateDeviceDir(UpdateDeviceDirVo updateDeviceDirVo) {
        DeviceDirEntity deviceDirEntity = (DeviceDirEntity)this.deviceDirRepository.getById((Serializable)updateDeviceDirVo.getId());
        if (null == deviceDirEntity) {
            log.error("\u76ee\u5f55\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u76ee\u5f55ID:{}", (Object)updateDeviceDirVo.getId());
            throw new ServiceException(ErrorEnum.DIR_NOT_EXISTS_ERROR);
        }
        DeviceDirEntity entity = this.deviceDirRepository.getDeviceDirEntityByDirCode(updateDeviceDirVo.getDirCode());
        if (null != entity && !entity.getId().equals(deviceDirEntity.getId())) {
            log.error("\u66f4\u65b0\u7684\u76ee\u5f55\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u76ee\u5f55\u7f16\u7801:{}", (Object)updateDeviceDirVo.getDirCode());
            throw new ServiceException(ErrorEnum.DIR_CODE_EXISTS_ERROR);
        }
        BeanUtils.copyProperties((Object)updateDeviceDirVo, (Object)deviceDirEntity);
        this.deviceDirRepository.updateById((Object)deviceDirEntity);
    }

    public void deleteDeviceDir(Long id) {
        DeviceDirEntity deviceDirEntity = (DeviceDirEntity)this.deviceDirRepository.getById((Serializable)id);
        if (null == deviceDirEntity) {
            log.error("\u89c6\u56fe\u76ee\u5f55\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u76ee\u5f55ID:{}", (Object)id);
            throw new ServiceException(ErrorEnum.DIR_NOT_EXISTS_ERROR);
        }
        long countDeviceDirEntity = this.deviceDirRepository.countDeviceDirEntityByParentId(id);
        if (countDeviceDirEntity > 0L) {
            log.error("\u89c6\u56fe\u76ee\u5f55\u5b58\u5728\u4e0b\u7ea7\u76ee\u5f55\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u76ee\u5f55ID:{}", (Object)id);
            throw new ServiceException(ErrorEnum.DIR_HAVE_LOWER_ERROR);
        }
        int countDevice = this.deviceMapper.countDeviceDirVoListByDirCode(deviceDirEntity.getDirCode());
        if (countDevice > 0) {
            log.error("\u89c6\u56fe\u76ee\u5f55\u5b58\u5728\u8bbe\u5907\u4fe1\u606f\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u76ee\u5f55\u7f16\u7801:{}", (Object)deviceDirEntity.getDirCode());
            throw new ServiceException(ErrorEnum.DIR_HAVE_DEVICE_ERROR);
        }
        this.deviceDirRepository.removeById((Serializable)id);
    }

    public DetailsDeviceDirVo getDeviceDir(Long id) {
        DeviceDirEntity deviceDirEntity = (DeviceDirEntity)this.deviceDirRepository.getById((Serializable)id);
        if (null == deviceDirEntity) {
            log.error("\u89c6\u56fe\u76ee\u5f55\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u76ee\u5f55ID:{}", (Object)id);
            throw new ServiceException(ErrorEnum.DIR_NOT_EXISTS_ERROR);
        }
        return DeviceDirConverter.INSTANCE.entityToDetailsVo(deviceDirEntity);
    }

    public List<NodeDeviceDirVo> listDeviceDir() {
        List allDeviceDirNodeVoList = DeviceDirConverter.INSTANCE.entitysToNodeVos(this.deviceDirRepository.list());
        List rootDeviceDirNodeVoList = this.getRootNode(allDeviceDirNodeVoList);
        ArrayList<NodeDeviceDirVo> nodeDeviceDirVoList = new ArrayList<NodeDeviceDirVo>();
        if (CollectionUtil.isNotEmpty((Collection)rootDeviceDirNodeVoList)) {
            for (NodeDeviceDirVo deviceDirNodeVo : rootDeviceDirNodeVoList) {
                this.buildChildTree(deviceDirNodeVo, allDeviceDirNodeVoList);
                nodeDeviceDirVoList.add(deviceDirNodeVo);
            }
            nodeDeviceDirVoList.sort(Comparator.comparing(BaseDeviceDirVo::getOrderNum));
            return nodeDeviceDirVoList;
        }
        return null;
    }

    private NodeDeviceDirVo buildChildTree(NodeDeviceDirVo deviceDirNodeVo, List<NodeDeviceDirVo> allDeviceDirNodeVoList) {
        ArrayList<NodeDeviceDirVo> childDeviceDirList = new ArrayList<NodeDeviceDirVo>();
        for (NodeDeviceDirVo node : allDeviceDirNodeVoList) {
            if (!node.getParentId().equals(deviceDirNodeVo.getId())) continue;
            childDeviceDirList.add(this.buildChildTree(node, allDeviceDirNodeVoList));
        }
        childDeviceDirList.sort(Comparator.comparing(BaseDeviceDirVo::getOrderNum));
        deviceDirNodeVo.setChildren(childDeviceDirList);
        return deviceDirNodeVo;
    }

    private List<NodeDeviceDirVo> getRootNode(List<NodeDeviceDirVo> allDeviceDirNodeVoList) {
        ArrayList<NodeDeviceDirVo> rootDeviceDirList = new ArrayList<NodeDeviceDirVo>();
        for (NodeDeviceDirVo deviceDirNodeVo : allDeviceDirNodeVoList) {
            if (deviceDirNodeVo.getParentId() != 0L) continue;
            rootDeviceDirList.add(deviceDirNodeVo);
        }
        return rootDeviceDirList;
    }

    public void doExcelImport(MultipartFile file) throws Exception {
        Workbook wb = this.checkExcel(file);
        Map dataMap = ReadExcelUtils.readExcelContent((Workbook)wb);
        for (Map.Entry mapEntry : dataMap.entrySet()) {
            Integer rowNum = (Integer)mapEntry.getKey();
            Integer factRowNum = rowNum + 1;
            Map map = (Map)mapEntry.getValue();
            String provinceName = this.checkAndGetValue(map.get(0), factRowNum);
            String provinceCode = this.checkAndGetValue(map.get(1), factRowNum);
            String cityName = this.checkAndGetValue(map.get(2), factRowNum);
            String cityCode = this.checkAndGetValue(map.get(3), factRowNum);
            String countyName = this.checkAndGetValue(map.get(4), factRowNum);
            String countyCode = this.checkAndGetValue(map.get(5), factRowNum);
            String regionName = this.checkAndGetValue(map.get(6), factRowNum);
            String regionCode = this.checkAndGetValue(map.get(7), factRowNum);
            ParentDeviceDirBean parentDeviceDirBean = new ParentDeviceDirBean(Long.valueOf(0L), Integer.valueOf(0));
            parentDeviceDirBean = this.checkSaveDeviceDir(provinceName, provinceCode, parentDeviceDirBean, factRowNum);
            parentDeviceDirBean = this.checkSaveDeviceDir(cityName, cityCode, parentDeviceDirBean, factRowNum);
            parentDeviceDirBean = this.checkSaveDeviceDir(countyName, countyCode, parentDeviceDirBean, factRowNum);
            this.checkSaveDeviceDir(regionName, regionCode, parentDeviceDirBean, factRowNum);
        }
    }

    public ParentDeviceDirBean checkSaveDeviceDir(String dirName, String dirCode, ParentDeviceDirBean parentDeviceDirBean, Integer factRowNum) {
        DeviceDirEntity entity = this.deviceDirRepository.getDeviceDirEntityByDirCode(dirCode);
        if (null != entity) {
            if (!entity.getParentId().equals(parentDeviceDirBean.getId())) {
                log.error("\u7b2c{}\u884c\u7684\u76ee\u5f55\u7f16\u7801\u5728\u5176\u5b83\u76ee\u5f55\u4e0b\u5df2\u5b58\u5728\uff0c\u76ee\u5f55\u7f16\u7801:{}", (Object)factRowNum, (Object)dirCode);
                throw new ServiceException(ErrorEnum.DIR_CODE_IS_EXISTS_ERROR.errorBean.processErrDesc(new Object[]{factRowNum}));
            }
            if (!entity.getDirName().equals(dirName)) {
                log.error("\u7b2c{}\u884c\u76ee\u5f55\u7f16\u7801\u548c\u76ee\u5f55\u540d\u79f0\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u7684\u4e0d\u4e00\u81f4\uff0c\u76ee\u5f55\u7f16\u7801:{}\uff0c\u76ee\u5f55\u540d\u79f0:{}", new Object[]{factRowNum, dirCode, dirName});
                throw new ServiceException(ErrorEnum.DIR_CODE_NOT_EQUAL_NAME_ERROR.errorBean.processErrDesc(new Object[]{factRowNum}));
            }
            if (4 == entity.getLevel()) {
                log.error("\u7b2c{}\u884c\u7684\u5c0f\u533a\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u76ee\u5f55\u7f16\u7801:{}\uff0c\u76ee\u5f55\u540d\u79f0:{}", new Object[]{factRowNum, dirCode, dirName});
                throw new ServiceException(ErrorEnum.DIR_REGION_EXISTS_LOWER_DIR_ERROR.errorBean.processErrDesc(new Object[]{factRowNum}));
            }
            return new ParentDeviceDirBean(entity.getId(), entity.getLevel());
        }
        DeviceDirEntity deviceDirEntity = new DeviceDirEntity();
        deviceDirEntity.setDirName(dirName);
        deviceDirEntity.setDirCode(dirCode);
        deviceDirEntity.setExpandState(Integer.valueOf(ExpandStateEnum.CLOSE.getStatus()));
        DeviceDirEntity maxDirEntity = this.deviceDirRepository.getMaxOrderNumByParentId(parentDeviceDirBean.getId());
        if (null == maxDirEntity) {
            deviceDirEntity.setOrderNum(Integer.valueOf(1));
        } else {
            deviceDirEntity.setOrderNum(Integer.valueOf(maxDirEntity.getOrderNum() + 1));
        }
        deviceDirEntity.setParentId(parentDeviceDirBean.getId());
        deviceDirEntity.setLevel(Integer.valueOf(parentDeviceDirBean.getLevel() + 1));
        this.deviceDirRepository.save((Object)deviceDirEntity);
        return new ParentDeviceDirBean(deviceDirEntity.getId(), deviceDirEntity.getLevel());
    }

    public String checkAndGetValue(Object obj, Integer factRowNum) {
        String str;
        String string = str = null == obj ? "" : obj.toString().trim();
        if (StringUtils.isBlank((CharSequence)str)) {
            log.error("\u7b2c{}\u884c\u5b58\u5728\u7a7a\u503c", (Object)factRowNum);
            throw new ServiceException(ErrorEnum.DIR_DATA_IS_NULL_ERROR.errorBean.processErrDesc(new Object[]{factRowNum}));
        }
        return str;
    }

    public Workbook checkExcel(MultipartFile file) throws IOException {
        HSSFWorkbook wb;
        if (null == file) {
            log.info("\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new ServiceException(ErrorEnum.FILE_NOT_EXISTS_ERROR);
        }
        log.info("\u6587\u4ef6\u5927\u5c0f:" + file.getSize() + "k");
        if (Objects.requireNonNull(file.getOriginalFilename()).endsWith("xls")) {
            wb = new HSSFWorkbook(file.getInputStream());
        } else if (file.getOriginalFilename().endsWith("xlsx")) {
            wb = new XSSFWorkbook(file.getInputStream());
        } else {
            log.error("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a{}\u6216{}", (Object)"xls", (Object)"xlsx");
            throw new ServiceException(ErrorEnum.FILE_TYPE_ERROR);
        }
        Sheet sheet = wb.getSheetAt(0);
        int lastRowIndex = sheet.getPhysicalNumberOfRows();
        int userIndex = lastRowIndex - 2;
        if (userIndex <= 0) {
            log.error("\u5bfc\u5165\u7684\u76ee\u5f55\u6570\u636e\u4e0d\u80fd\u5c11\u4e8e1\u6761");
            throw new ServiceException(ErrorEnum.GREATER_THAN_EXCEL_MIN_SIZE);
        }
        int lastCellIndex = sheet.getRow(2).getPhysicalNumberOfCells();
        if (lastCellIndex != 8) {
            log.error("\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u5217\u6570\u5fc5\u987b\u4e3a\uff1a{}", (Object)8);
            throw new ServiceException(ErrorEnum.TEMPLATE_FORMAT_ERROR);
        }
        return wb;
    }

    public DeviceDirServiceImpl(IDeviceDirRepository deviceDirRepository, DeviceMapper deviceMapper) {
        this.deviceDirRepository = deviceDirRepository;
        this.deviceMapper = deviceMapper;
    }
}

