/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.dir.utils;

import com.xdja.saps.view.common.core.exception.ServiceException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReadExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ReadExcelUtils.class);

    public static Map<Integer, Map<Integer, Object>> readExcelContent(Workbook wb) throws Exception {
        HashMap<Integer, Map<Integer, Object>> content = new HashMap<Integer, Map<Integer, Object>>();
        Sheet sheet = wb.getSheetAt(0);
        int rowNum = sheet.getLastRowNum();
        int colNum = sheet.getRow(2).getPhysicalNumberOfCells();
        for (int i = 2; i <= rowNum; ++i) {
            Row row = sheet.getRow(i);
            HashMap<Integer, Object> cellValue = new HashMap<Integer, Object>();
            for (int j = 0; j < colNum; ++j) {
                Object obj = null;
                if (row != null) {
                    obj = ReadExcelUtils.getCellFormatValue((Cell)row.getCell(j));
                }
                cellValue.put(j, obj);
            }
            content.put(i, cellValue);
        }
        return content;
    }

    private static Object getCellFormatValue(Cell cell) {
        Object result = null;
        if (cell != null) {
            int cellType = cell.getCellType();
            switch (cellType) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    result = new DecimalFormat("#").format(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    result = cell.getNumericCellValue();
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new ServiceException("\u672a\u77e5\u7684EXCEL\u5355\u5143\u683c\u7c7b\u578b");
                }
            }
        }
        return result;
    }
}

