/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.superiorPlatform.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xdja.saps.view.common.core.bean.PageInfo;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.common.http.SapsViewHttpClient;
import com.xdja.saps.view.system.config.SapsViewPlatformConfig;
import com.xdja.saps.view.system.superiorPlatform.converter.SuperiorPlatformConverter;
import com.xdja.saps.view.system.superiorPlatform.entity.SuperiorPlatformInfoEntity;
import com.xdja.saps.view.system.superiorPlatform.repository.ISuperiorPlatformRepository;
import com.xdja.saps.view.system.superiorPlatform.service.ISuperiorPlatformService;
import com.xdja.saps.view.system.superiorPlatform.vo.SuperiorPlatformVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SuperiorPlatformServiceImpl
implements ISuperiorPlatformService {
    private static final Logger log = LoggerFactory.getLogger(SuperiorPlatformServiceImpl.class);
    private final ISuperiorPlatformRepository superiorPlatformRepository;
    private final SapsViewHttpClient httpClient;
    private final SapsViewPlatformConfig sapsViewPlatformConfig;

    public PageInfo<SuperiorPlatformVo> listPlatformInfoPage(Integer pageNo, Integer pageSize) {
        Page queryPage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.superiorPlatformRepository.page((IPage)queryPage);
        List resultList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)queryPage.getRecords())) {
            resultList = SuperiorPlatformConverter.INSTANCE.entityListToVoList(queryPage.getRecords());
        }
        return new PageInfo(queryPage.getPages(), queryPage.getTotal(), resultList);
    }

    public SuperiorPlatformVo getDetail(Long id) {
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)id);
        if (null == platformInfoEntity) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        return SuperiorPlatformConverter.INSTANCE.entityToVo(platformInfoEntity);
    }

    public void savePlatformInfo(SuperiorPlatformVo superiorPlatformVo) {
        this.checkParamUnique(superiorPlatformVo, true);
        SuperiorPlatformInfoEntity platformInfoEntity = SuperiorPlatformConverter.INSTANCE.voToEntity(superiorPlatformVo);
        this.superiorPlatformRepository.save((Object)platformInfoEntity);
        this.notifyRegisterToSuper();
    }

    public void modifyPlatformInfo(SuperiorPlatformVo superiorPlatformVo) {
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)superiorPlatformVo.getId());
        if (null == platformInfoEntity) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        this.checkParamUnique(superiorPlatformVo, false);
        platformInfoEntity = SuperiorPlatformConverter.INSTANCE.voToEntity(superiorPlatformVo);
        this.superiorPlatformRepository.updateById((Object)platformInfoEntity);
        this.notifyRegisterToSuper();
    }

    public void deletePlatformInfo(Long id) {
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)id);
        if (null == platformInfoEntity) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        this.superiorPlatformRepository.removeById((Serializable)id);
        this.notifyRegisterToSuper();
    }

    private void notifyRegisterToSuper() {
        try {
            this.httpClient.get(this.sapsViewPlatformConfig.getRegisterUrl());
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u89c6\u56fe\u670d\u52a1\u5411\u4e0a\u7ea7\u6ce8\u518c\u5931\u8d25", (Throwable)e);
        }
    }

    private void checkParamUnique(SuperiorPlatformVo superiorPlatformVo, boolean isAdd) {
        Long id;
        Long l = id = isAdd ? null : superiorPlatformVo.getId();
        if (this.superiorPlatformRepository.existDeviceCode(superiorPlatformVo.getDeviceCode(), id)) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_DEVICE_CODE_EXISTS);
        }
        if (this.superiorPlatformRepository.existDeviceField(superiorPlatformVo.getDeviceField(), id)) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_DEVICE_FIELD_EXISTS);
        }
    }

    public SuperiorPlatformServiceImpl(ISuperiorPlatformRepository superiorPlatformRepository, SapsViewHttpClient httpClient, SapsViewPlatformConfig sapsViewPlatformConfig) {
        this.superiorPlatformRepository = superiorPlatformRepository;
        this.httpClient = httpClient;
        this.sapsViewPlatformConfig = sapsViewPlatformConfig;
    }
}

