/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.controller;

import com.xdja.saps.view.system.user.bean.RoleVo;
import com.xdja.saps.view.system.user.bean.UserVo;
import com.xdja.saps.view.system.user.service.UserManagerService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/v1/sys/account"})
@RestController
public class UserManagerController {
    private static final Logger log = LoggerFactory.getLogger(UserManagerController.class);
    private final UserManagerService userManagerService;

    @PostMapping(value={"/addUser"})
    public Object createUser(@Validated @RequestBody UserVo userVO) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u6570\u636e\u4e3a{}", (Object)userVO.toString());
        }
        return this.userManagerService.insertUser(userVO).getData();
    }

    @GetMapping(value={"/getUserInfo"})
    public Object getUserInfo(@RequestParam Long userId) {
        return this.userManagerService.getUserInfo(userId).getData();
    }

    @PostMapping(value={"/editUser"})
    public Object changeUser(@RequestBody UserVo userVO) {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u6570\u636e\u4e3a{}", (Object)userVO.toString());
        }
        return this.userManagerService.updateUser(userVO).getData();
    }

    @PostMapping(value={"/deleteUser"})
    public Object deleteUser(@RequestBody HashMap<String, Long> userId) {
        return this.userManagerService.deleteUser(userId.get("userId")).getData();
    }

    @GetMapping(value={"/getUserList"})
    public Object listUser() {
        return this.userManagerService.listUser().getData();
    }

    @PostMapping(value={"/resetPwd"})
    public Object listUser(@RequestBody HashMap<String, Long> userId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u6570\u636e\u4e3a{}", userId);
        }
        return this.userManagerService.resetPasswd(userId.get("userId")).getData();
    }

    @GetMapping(value={"/getRoleList"})
    public Object listRole() {
        return this.userManagerService.listRole().getData();
    }

    @GetMapping(value={"/getRoleInfo"})
    public Object getRoleInfo(@RequestParam Long userId) {
        return this.userManagerService.getRoleInfo(userId).getData();
    }

    @PostMapping(value={"/setRoleInfo"})
    public Object updateRoleInfo(@RequestBody RoleVo roleVo) {
        return this.userManagerService.updateRole(roleVo).getData();
    }

    @GetMapping(value={"/getPermissionRoleList"})
    public Object getPermissionRoleList(@RequestParam Long userId) {
        return this.userManagerService.getPermissionRoleList(userId).getData();
    }

    public UserManagerController(UserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }
}

