/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.system.auth.utils.OperatorUtil;
import com.xdja.saps.view.system.user.bean.RoleEnumVo;
import com.xdja.saps.view.system.user.bean.forms.FormsVo;
import com.xdja.saps.view.system.user.bean.forms.Meta;
import com.xdja.saps.view.system.user.entity.MenuEntity;
import com.xdja.saps.view.system.user.entity.RoleEntity;
import com.xdja.saps.view.system.user.entity.RoleMenuEntity;
import com.xdja.saps.view.system.user.mapper.FunctionMapper;
import com.xdja.saps.view.system.user.repository.RoleMenuRepository;
import com.xdja.saps.view.system.user.repository.RoleRepository;
import com.xdja.saps.view.system.user.repository.UserRepository;
import com.xdja.saps.view.system.user.service.FunctionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FunctionServiceImpl
implements FunctionService {
    private static final Logger log = LoggerFactory.getLogger(FunctionServiceImpl.class);
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final RoleMenuRepository roleMenuRepository;
    private final FunctionMapper functionMapper;

    public Result getRoleMenu(Long roleId) {
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)roleId);
        Page roleMenuEntityPage = this.roleMenuRepository.selectRoleMenuPage(roleId.longValue());
        HashMap<String, Integer> roleMenuMap = new HashMap<String, Integer>();
        for (RoleMenuEntity record : roleMenuEntityPage.getRecords()) {
            Integer type = OperatorUtil.getOperatorRoleType();
            if (Objects.equals(type, roleEntity.getType())) {
                roleMenuMap.put(record.getAlias(), 0);
                continue;
            }
            roleMenuMap.put(record.getAlias(), record.getStatus());
        }
        return Result.success(roleMenuMap);
    }

    public Result saveRoleMenu(RoleEnumVo roleEnumVo) {
        Long roleId = roleEnumVo.getRoleId();
        Page roleMenuEntityPage = this.roleMenuRepository.selectRoleMenuPage(roleId.longValue());
        for (RoleMenuEntity record : roleMenuEntityPage.getRecords()) {
            String alias = record.getAlias();
            HashMap enumVo = roleEnumVo.getRoleInfo();
            record.setStatus((Integer)enumVo.get(alias));
            this.roleMenuRepository.updateById((Object)record);
        }
        return Result.success();
    }

    public Result getFormsInfo() {
        String loginName = OperatorUtil.getOperatorUserName();
        List menuEntityList = this.functionMapper.selectMenuByLoginName(loginName, 0L);
        HashMap<Long, FormsVo> father = new HashMap<Long, FormsVo>();
        for (MenuEntity menuEntity : menuEntityList) {
            FormsVo formsVo = this.entityToFormsVo(menuEntity);
            father.put(menuEntity.getId(), formsVo);
            List childrenEntity = this.functionMapper.selectMenuByLoginName(loginName, menuEntity.getId().longValue());
            ArrayList<FormsVo> children = new ArrayList<FormsVo>();
            for (MenuEntity entity : childrenEntity) {
                FormsVo childrenVo = this.entityToFormsVo(entity);
                children.add(childrenVo);
            }
            formsVo.setChildren(children);
        }
        return Result.success(father.values());
    }

    private FormsVo entityToFormsVo(MenuEntity menuEntity) {
        FormsVo formsVo = new FormsVo();
        formsVo.setName(menuEntity.getObjName());
        formsVo.setPath(menuEntity.getLink());
        formsVo.setComponent(menuEntity.getComponent());
        Meta meta = new Meta();
        meta.setComponent(menuEntity.getComponent());
        meta.setPath(menuEntity.getLink());
        meta.setIcon(menuEntity.getIcon());
        meta.setTitle(menuEntity.getName());
        meta.setShow(menuEntity.isShow());
        meta.setHasAppend(menuEntity.isHasAppend());
        formsVo.setMeta(meta);
        return formsVo;
    }

    public FunctionServiceImpl(UserRepository userRepository, RoleRepository roleRepository, RoleMenuRepository roleMenuRepository, FunctionMapper functionMapper) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.roleMenuRepository = roleMenuRepository;
        this.functionMapper = functionMapper;
    }
}

