/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.service.impl;

import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.system.auth.bean.Operator;
import com.xdja.saps.view.system.auth.utils.OperatorUtil;
import com.xdja.saps.view.system.auth.utils.SessionUtils;
import com.xdja.saps.view.system.user.bean.ChangePasswdVo;
import com.xdja.saps.view.system.user.bean.UserLoginVo;
import com.xdja.saps.view.system.user.entity.RoleEntity;
import com.xdja.saps.view.system.user.entity.UserEntity;
import com.xdja.saps.view.system.user.mapper.FunctionMapper;
import com.xdja.saps.view.system.user.repository.RoleRepository;
import com.xdja.saps.view.system.user.repository.UserRepository;
import com.xdja.saps.view.system.user.service.UserLoginService;
import com.xdja.saps.view.system.user.util.PasswordUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserLoginServiceImpl
implements UserLoginService {
    private static final Logger log = LoggerFactory.getLogger(UserLoginServiceImpl.class);
    private final UserRepository userRepository;
    private final FunctionMapper functionMapper;
    private final CacheManager cacheManager;
    private final SessionManager sessionManager;
    private final RoleRepository roleRepository;

    public Result userLogin(UserLoginVo userLoginVO) throws Exception {
        if (null == userLoginVO.getUserName() || null == userLoginVO.getPassword()) {
            String requestMsg = userLoginVO.toString();
            log.error("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)requestMsg);
            throw new ServiceException(ErrorEnum.REQUEST_PARAMS_ERROR);
        }
        UserEntity userEntity = this.userRepository.selectByName(userLoginVO.getUserName());
        if (null == userEntity) {
            log.error("\u7528\u6237{}\u4e0d\u5b58\u5728", (Object)userLoginVO.getUserName());
            throw new ServiceException(ErrorEnum.USER_DOES_NOT_EXIST);
        }
        Result checkPasswordResult = this.checkPassword(PasswordUtils.encodePasswordSHA256((String)userLoginVO.getPassword()), userEntity, false);
        Subject subject = SecurityUtils.getSubject();
        subject.login((AuthenticationToken)new UsernamePasswordToken(userLoginVO.getUserName(), (String)checkPasswordResult.getData()));
        List function = this.functionMapper.selectFunctionByLoginName(userLoginVO.getUserName());
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)userEntity.getRoleId());
        log.debug("\u5f53\u524d\u7528\u6237\u6743\u9650\uff1a{}", (Object)function);
        Operator operator = new Operator(userEntity.getName(), userEntity.getId(), roleEntity.getType(), function);
        OperatorUtil.setOperator((Operator)operator);
        this.putCacheUserSession();
        HashMap<String, Object> loginMap = new HashMap<String, Object>();
        loginMap.put("userId", String.valueOf(userEntity.getId()));
        loginMap.put("roleType", roleEntity.getType());
        Serializable id = subject.getSession().getId();
        loginMap.put("token", id);
        return Result.success(loginMap);
    }

    private Result checkPassword(String userPassword, UserEntity userDO, boolean isChange) {
        if (!userPassword.equals(userDO.getPassword())) {
            if (isChange) {
                log.error("\u539f\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff0c\u524d\u7aef\u4f20\u5165\u5bc6\u7801\u4e3a{}\uff0c\u6570\u636e\u5e93\u5bc6\u7801\u4e3a{}", (Object)userPassword, (Object)userDO.getPassword());
                throw new ServiceException(ErrorEnum.ORIGIN_PASSWORD_IS_ERROR);
            }
            log.error("\u9a8c\u8bc1\u767b\u5f55\u5bc6\u7801\u5931\u8d25\uff0c\u524d\u7aef\u4f20\u5165\u540e\u5bc6\u7801\u4e3a{}\uff0c\u6570\u636e\u5e93\u5bc6\u7801\u4e3a{}", (Object)userPassword, (Object)userDO.getPassword());
            throw new ServiceException(ErrorEnum.PASSWORD_VERIFY_ERROR);
        }
        return Result.success((Object)userPassword, null);
    }

    public Result changePassword(ChangePasswdVo vo) throws Exception {
        String oldPassword = vo.getSrcPwd();
        UserEntity userEntity = (UserEntity)this.userRepository.getById((Serializable)Long.valueOf(vo.getUserId()));
        this.checkPassword(PasswordUtils.encodePasswordSHA256((String)oldPassword), userEntity, true);
        String newPassword = vo.getNewPwd();
        newPassword = PasswordUtils.encodePasswordSHA256((String)newPassword);
        if (newPassword.length() != 64) {
            log.error("\u524d\u7aef\u4f20\u5165\u4fee\u6539\u540e\u7684\u7684\u5bc6\u7801\u4f4d\u6570\u4e3a{}\uff0c\u6570\u636e\u4e3a{}", (Object)newPassword.length(), (Object)newPassword);
            throw new ServiceException(ErrorEnum.PASSWORD_FORMAT_ERROR);
        }
        if (newPassword.equals(oldPassword)) {
            log.error("\u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c\uff0c\u4e3a{}", (Object)newPassword);
            throw new ServiceException(ErrorEnum.ORIGIN_PASSWORD_IS_EQUALS_TO_NEW_PASSWORD);
        }
        userEntity.setPassword(newPassword);
        this.userRepository.updateById((Object)userEntity);
        log.info("\u7528\u6237{}\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff0c", (Object)userEntity.getName());
        return Result.success();
    }

    public Result userLogout() {
        Subject subject = SecurityUtils.getSubject();
        if (null == subject.getPrincipal()) {
            return Result.success();
        }
        this.deleteCacheSessionId(subject);
        subject.logout();
        return Result.success();
    }

    private void deleteCacheSessionId(Subject subject) {
        Cache cache = this.cacheManager.getCache("shiro-kickout-session");
        Session session = subject.getSession();
        String username = (String)subject.getPrincipal();
        Serializable sessionId = session.getId();
        SessionUtils.removeCacheSession((String)username, (Serializable)sessionId, (Cache)cache);
        Session kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(sessionId));
        if (null != kickoutSession) {
            kickoutSession.setAttribute((Object)"kickout", (Object)true);
        }
    }

    private void putCacheUserSession() {
        Subject subject = SecurityUtils.getSubject();
        Cache cache = this.cacheManager.getCache("shiro-kickout-session");
        SessionUtils.saveAndKickoutSession((Cache)cache, (boolean)false, (SessionManager)this.sessionManager, (Subject)subject);
    }

    public UserLoginServiceImpl(UserRepository userRepository, FunctionMapper functionMapper, CacheManager cacheManager, SessionManager sessionManager, RoleRepository roleRepository) {
        this.userRepository = userRepository;
        this.functionMapper = functionMapper;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.roleRepository = roleRepository;
    }
}

