/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.enums.RoleTypeEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.system.auth.utils.OperatorUtil;
import com.xdja.saps.view.system.user.bean.RoleVo;
import com.xdja.saps.view.system.user.bean.UserDetailVo;
import com.xdja.saps.view.system.user.bean.UserInfoVo;
import com.xdja.saps.view.system.user.bean.UserVo;
import com.xdja.saps.view.system.user.converter.UserConverter;
import com.xdja.saps.view.system.user.entity.RoleEntity;
import com.xdja.saps.view.system.user.entity.UserEntity;
import com.xdja.saps.view.system.user.repository.RoleRepository;
import com.xdja.saps.view.system.user.repository.UserRepository;
import com.xdja.saps.view.system.user.service.UserManagerService;
import com.xdja.saps.view.system.user.util.PasswordUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserManagerServiceImpl
implements UserManagerService {
    private static final Logger log = LoggerFactory.getLogger(UserManagerServiceImpl.class);
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private String originPassWd = "Xdja@123";

    public Result insertUser(UserVo vo) throws Exception {
        if (StringUtils.isBlank((CharSequence)vo.getPassword()) || null == vo.getRoleType() || StringUtils.isBlank((CharSequence)vo.getCurrentUserId())) {
            String msg = vo.toString();
            log.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)msg);
            throw new ServiceException(ErrorEnum.REQUEST_PARAMS_ERROR);
        }
        String userName = vo.getName();
        long count = this.userRepository.countByName(userName);
        if (count > 0L) {
            log.error("\u7528\u6237\u540d\u5df2\u5b58\u5728\uff0c\u7528\u6237\u540d\u4e3a{}", (Object)userName);
            throw new ServiceException(ErrorEnum.USER_NAME_IS_EXIST);
        }
        if (userName.length() > 30) {
            log.error("\u7528\u6237\u540d\u957f\u5ea6\u6709\u8bef\uff0c\u7528\u6237\u540d\u4e3a{}\uff0c\u957f\u5ea6\u4e3a{}", (Object)userName, (Object)userName.length());
            throw new ServiceException(ErrorEnum.PERSON_NAME_IS_TOO_LONG);
        }
        return this.saveData(vo);
    }

    public Result getUserInfo(Long userId) {
        UserEntity userEntity = (UserEntity)this.userRepository.getById((Serializable)userId);
        if (null == userEntity) {
            throw new ServiceException(ErrorEnum.USER_NOT_IS_EXIST);
        }
        UserDetailVo userDetailVo = UserConverter.INSTANCE.entityToDto(userEntity);
        userDetailVo.setUserId(userEntity.getId());
        return Result.success((Object)userDetailVo);
    }

    private Result saveData(UserVo vo) throws Exception {
        UserEntity userDO = new UserEntity();
        userDO.setName(vo.getName());
        userDO.setPassword(PasswordUtils.encodePasswordSHA256((String)vo.getPassword()));
        RoleEntity roleEntity = this.roleRepository.selectByType(vo.getRoleType().intValue());
        userDO.setRoleId(roleEntity.getId());
        this.userRepository.save((Object)userDO);
        return Result.success();
    }

    public Result updateUser(UserVo vo) {
        String id = vo.getUserId();
        UserEntity userEntity = (UserEntity)this.userRepository.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == userEntity) {
            throw new ServiceException(ErrorEnum.USER_NOT_IS_EXIST);
        }
        userEntity.setName(vo.getName());
        RoleEntity roleEntity = this.roleRepository.selectByType(vo.getRoleType().intValue());
        userEntity.setRoleId(roleEntity.getId());
        this.userRepository.updateById((Object)userEntity);
        return Result.success();
    }

    public Result deleteUser(Long id) {
        UserEntity userEntity = (UserEntity)this.userRepository.getById((Serializable)id);
        if (null == userEntity) {
            throw new ServiceException(ErrorEnum.USER_NOT_IS_EXIST);
        }
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)userEntity.getRoleId());
        Integer type = OperatorUtil.getOperatorRoleType();
        if (type >= roleEntity.getType()) {
            log.error("\u4ec5\u4e0a\u7ea7\u5220\u9664\u4e0b\u7ea7\uff0cuserId");
            throw new ServiceException(ErrorEnum.NO_PERMISSION_IS_DELETE);
        }
        this.userRepository.removeById((Object)userEntity);
        return Result.success();
    }

    public Result resetPasswd(Long id) throws Exception {
        UserEntity userEntity = (UserEntity)this.userRepository.getById((Serializable)id);
        if (null == userEntity) {
            throw new ServiceException(ErrorEnum.USER_NOT_IS_EXIST);
        }
        userEntity.setPassword(PasswordUtils.encodePasswordSHA256((String)this.originPassWd));
        this.userRepository.updateById((Object)userEntity);
        return Result.success();
    }

    public Result listUser() {
        ArrayList<UserInfoVo> result = new ArrayList<UserInfoVo>();
        Page pageInfo = this.userRepository.selectPage();
        for (UserEntity userEntity : pageInfo.getRecords()) {
            UserInfoVo responseVO = new UserInfoVo();
            responseVO.setName(userEntity.getName());
            RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)userEntity.getRoleId());
            responseVO.setRoleType(roleEntity.getType());
            responseVO.setUserId(userEntity.getId());
            responseVO.setCreateTime(userEntity.getCreateTime().toString());
            result.add(responseVO);
        }
        return Result.success(result);
    }

    public Result listRole() {
        ArrayList<RoleVo> result = new ArrayList<RoleVo>();
        Integer operatorRoleType = OperatorUtil.getOperatorRoleType();
        Page roleEntityList = this.roleRepository.selectPage(operatorRoleType);
        for (RoleEntity roleEntity : roleEntityList.getRecords()) {
            RoleVo roleVo = UserConverter.INSTANCE.entityToDto(roleEntity);
            result.add(roleVo);
        }
        return Result.success(result);
    }

    public Result getRoleInfo(Long id) {
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)id);
        RoleVo roleVo = UserConverter.INSTANCE.entityToDto(roleEntity);
        return Result.success((Object)roleVo);
    }

    public Result updateRole(RoleVo roleVo) {
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)roleVo.getId());
        if (!this.roleRepository.isUniqueness(roleVo.getName(), roleEntity.getId())) {
            throw new ServiceException(ErrorEnum.ROLE_NAME_IS_REPEAT);
        }
        roleEntity.setName(roleVo.getName());
        roleEntity.setRemark(roleVo.getRemark());
        this.roleRepository.updateById((Object)roleEntity);
        return Result.success();
    }

    public Result getPermissionRoleList(Long id) {
        ArrayList<Integer> roleTypeList = new ArrayList<Integer>();
        roleTypeList.add(RoleTypeEnum.AUDIT_OPERATOR.getType());
        roleTypeList.add(RoleTypeEnum.OPERATE_ADMIN.getType());
        RoleEntity roleEntity = (RoleEntity)this.roleRepository.getById((Serializable)id);
        if (RoleTypeEnum.SYSTEM_ADMIN.getType() == roleEntity.getType().intValue()) {
            roleTypeList.add(RoleTypeEnum.SAFE_ADMIN.getType());
        }
        HashMap<String, ArrayList<Integer>> resMap = new HashMap<String, ArrayList<Integer>>();
        resMap.put("roles", roleTypeList);
        return Result.success(resMap);
    }

    public UserManagerServiceImpl(UserRepository userRepository, RoleRepository roleRepository) {
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
    }
}

