/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.api;

import com.rabbitmq.client.Channel;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.extension.MessageAdapter;
import com.xdja.sc.model.Msg;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CallerAdapter
extends ReceivedAction {
    private static Logger logger = Logger.getLogger(CallerAdapter.class);
    private HashMap<String, MessageCallback> actionMap = new HashMap();

    public CallerAdapter(MessageCallback[] msgCallbacks) throws Exception {
        for (MessageCallback caller : msgCallbacks) {
            this.actionMap.put(caller.getTopicId(), caller);
        }
        MQSetting.initChanel(Arrays.asList(this.actionMap.keySet().toArray(new String[this.actionMap.size()])));
    }

    @Override
    public void delivery(Msg msg, long deliveryTag, Channel channel, boolean autoAck) {
        boolean flag = true;
        if (this.actionMap.containsKey(msg.type)) {
            flag = this.actionMap.get(msg.type).process(MessageAdapter.convertMessage(msg));
            logger.debug((Object)("CallerAdapter process msg : " + msg));
        } else {
            logger.error((Object)("CallerAdapter process msg but NOT FIND msgCallback !!! ==> " + msg));
        }
        if (!autoAck) {
            try {
                if (flag) {
                    channel.basicAck(deliveryTag, true);
                } else {
                    channel.basicNack(deliveryTag, false, true);
                }
            }
            catch (IOException e) {
                logger.error((Object)("Ack error ==> " + e));
            }
        }
    }
}

