/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.consumer;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.xdja.sc.client.consumer.MQReceiverManager;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.core.Connnector;
import com.xdja.sc.client.core.MQSetting;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Receiver
extends Connnector
implements Runnable,
Consumer {
    private boolean AUTO_ACK = false;
    private static Logger logger = Logger.getLogger(Receiver.class);
    private static final int THREAD_COUNT = 5;
    private ReceivedAction action;
    private String conStr;

    public Receiver(String conStrs, ReceivedAction act) throws Exception {
        super(conStrs, 5);
        this.action = act;
        this.conStr = conStrs;
    }

    public Receiver(String conStrs, ReceivedAction act, boolean AutoAck) throws Exception {
        super(conStrs, 5);
        this.action = act;
        this.conStr = conStrs;
        this.AUTO_ACK = AutoAck;
    }

    public void handleCancel(String arg0) throws IOException {
        logger.debug((Object)("handleCancel == >" + arg0));
    }

    public void handleCancelOk(String arg0) {
        logger.debug((Object)("handleCancelOk == >" + arg0));
    }

    public void handleConsumeOk(String consumerTag) {
        logger.debug((Object)("handleConsumeOk == >" + consumerTag));
    }

    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.action.delivery(body, env.getDeliveryTag(), this.channel, this.AUTO_ACK);
    }

    public void handleRecoverOk(String arg0) {
        logger.debug((Object)("handleRecoverOk == >" + arg0));
    }

    public void handleShutdownSignal(String ConsumerTag, ShutdownSignalException exception) {
        this.action.handleShutdownSingal(ConsumerTag, exception);
    }

    @Override
    public void run() {
        try {
            this.channel.basicConsume(MQSetting.Queue, this.AUTO_ACK, (Consumer)this);
        }
        catch (IOException e) {
            logger.error((Object)e);
            MQReceiverManager.getInstance().removeReceiver(this.conStr);
        }
    }
}

