/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.extension;

import com.xdja.sc.codec.Codec;
import com.xdja.sc.codec.CodecFactory;
import com.xdja.sc.model.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileQueue {
    private static final long INTERVAL = 1000L;
    private static Logger logger = Logger.getLogger(FileQueue.class);
    private static Path path;
    private static boolean fileLock;
    private static Codec codec;
    private static final String spliter = "$$";
    private static final String file_name = "xdja_sc.queue";

    private static void CheckPath() {
        if (!FileQueue.exists()) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static boolean exists() {
        return Files.exists(path, new LinkOption[0]);
    }

    public static void writeMsg(Msg msg) throws Exception {
        if (!fileLock) {
            FileQueue.CheckPath();
            byte[] bytes = codec.serialize(msg);
            int body_length = bytes.length;
            Files.write(path, FileQueue.sysCopy(spliter.getBytes(Charset.forName("UTF-8")), FileQueue.intToByteArray(body_length), codec.serialize(msg)), StandardOpenOption.APPEND);
        } else {
            Thread.sleep(1000L);
            FileQueue.writeMsg(msg);
        }
    }

    public static void writeMsg(List<Msg> msgs) throws Exception {
        for (Msg msg : msgs) {
            FileQueue.writeMsg(msg);
        }
    }

    public static List<Msg> readMsg() throws IOException {
        FileQueue.CheckPath();
        ArrayList<Msg> resualt = new ArrayList<Msg>();
        fileLock = true;
        File file = path.toFile();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            FileQueue.readMsgByStream(in, resualt);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Files.delete(path);
        fileLock = false;
        return resualt;
    }

    private static List<Msg> readMsgByStream(InputStream in, List<Msg> resualt) throws IOException {
        int flag = 1;
        block6: while (flag > 0) {
            String spliter_str;
            byte[] spliter_bytes = new byte[2];
            flag = in.read(spliter_bytes);
            switch (spliter_str = new String(spliter_bytes)) {
                case "$$": {
                    logger.debug((Object)"\u786e\u8ba4\u5206\u9694\u7b26\uff0c\u5f00\u59cb\u8bfb\u53d6\u6570\u636e");
                    byte[] len_bytes = new byte[4];
                    flag = in.read(len_bytes);
                    int len = FileQueue.byteArrayToInt(len_bytes);
                    logger.debug((Object)("Msg\u6570\u636e\u5927\u5c0f\u4e3a : " + len));
                    if (len <= 0) continue block6;
                    byte[] msg_bytes = new byte[len];
                    flag = in.read(msg_bytes);
                    resualt.add(codec.deSerialize(msg_bytes));
                    continue block6;
                }
            }
            if (flag != -1) {
                logger.error((Object)("spliter is not defined !!! : [" + spliter_str + "]"));
                flag = -1;
                continue;
            }
            logger.info((Object)"File EOF");
        }
        return resualt;
    }

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static byte[] intToByteArray(int a) {
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static byte[] sysCopy(byte[] ... srcArrays) {
        int len = 0;
        for (byte[] srcArray : srcArrays) {
            len += srcArray.length;
        }
        byte[] destArray = new byte[len];
        int destLen = 0;
        for (byte[] srcArray : srcArrays) {
            System.arraycopy(srcArray, 0, destArray, destLen, srcArray.length);
            destLen += srcArray.length;
        }
        return destArray;
    }

    static {
        fileLock = false;
        codec = CodecFactory.getCodec();
        path = Paths.get(new File(file_name).getAbsolutePath(), new String[0]);
        FileQueue.CheckPath();
    }
}

