/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.producer;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.extension.FileQueue;
import com.xdja.sc.client.extension.TaskManager;
import com.xdja.sc.client.producer.Sender;
import com.xdja.sc.client.producer.Transmitter;
import com.xdja.sc.model.Msg;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class SuperTransmitter {
    private static final int RING_BUFFER_SIZE = 0x200000;
    private static Disruptor<Msg> disruptor;
    private static SuperTransmitter transmitter;
    private static Logger logger;
    private static RingBuffer<Msg> ringBuffer;

    private SuperTransmitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SuperTransmitter getInstance() throws Exception {
        if (transmitter != null) return transmitter;
        Class<Transmitter> clazz = Transmitter.class;
        synchronized (Transmitter.class) {
            if (transmitter != null) return transmitter;
            transmitter = new SuperTransmitter();
            ExecutorService excs = Executors.newFixedThreadPool(MQSetting.THREAD_SIZE);
            disruptor = new Disruptor((EventFactory)new EventFactory<Msg>(){

                public Msg newInstance() {
                    return new Msg();
                }
            }, 0x200000, (Executor)excs);
            for (int i = 0; i < MQSetting.THREAD_SIZE; ++i) {
                disruptor.handleEventsWith(new EventHandler[]{new SendTask(i)});
            }
            ringBuffer = disruptor.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transmitter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(String topic, Msg msg) {
        msg.type = topic;
        msg.producer = MQSetting.Queue;
        long seq = ringBuffer.next();
        try {
            Msg valueEvent = (Msg)ringBuffer.get(seq);
            this.copyFrom(valueEvent, msg);
        }
        finally {
            ringBuffer.publish(seq);
        }
        return 1;
    }

    private void copyFrom(Msg des, Msg msg) {
        des.id = msg.id;
        des.content = msg.content;
        des.timestamp = msg.timestamp;
        des.type = msg.type;
    }

    static {
        logger = Logger.getLogger(SuperTransmitter.class);
    }

    private static final class SendTask
    implements EventHandler<Msg> {
        private Sender sender = new Sender(MQSetting.url);
        private int index;

        public SendTask(int index) throws Exception {
            this.index = index;
        }

        public void onEvent(Msg msg, long sequence, boolean endOfBatch) throws Exception {
            if (sequence % (long)MQSetting.THREAD_SIZE == (long)this.index) {
                int flag = 1;
                try {
                    flag = this.sender.sendMessage(msg.type, msg);
                }
                catch (Exception e) {
                    logger.error((Object)("Transmitter call SendTask send error [" + e + "] and flag == >\u3000" + flag));
                    e.printStackTrace();
                    try {
                        if (flag > 0) {
                            FileQueue.writeMsg(msg);
                            logger.error((Object)("Transmitter send msg error save " + msg));
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        logger.error((Object)("Transmitter save msg error : " + e1));
                    }
                    if (!TaskManager.getInstance().isStart()) {
                        TaskManager.getInstance().start();
                    }
                    flag = -1;
                }
            }
        }
    }
}

