/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.dynamic.manager;

import android.content.ComponentName;
import android.content.Context;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.RemoteException;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.dynamic.host.FailedException;
import com.tencent.shadow.dynamic.host.MultiLoaderPluginProcessService;
import com.tencent.shadow.dynamic.host.MultiLoaderPpsController;
import com.tencent.shadow.dynamic.host.PluginManagerImpl;
import com.tencent.shadow.dynamic.host.PpsStatus;
import com.tencent.shadow.dynamic.loader.PluginLoader;
import com.tencent.shadow.dynamic.manager.BaseDynamicPluginManager;
import com.tencent.shadow.dynamic.manager.BinderPluginLoader;
import com.tencent.shadow.dynamic.manager.PluginManagerThatUseDynamicLoader;
import com.tencent.shadow.dynamic.manager.UuidManagerBinder;
import com.tencent.shadow.dynamic.manager.UuidManagerImpl;

public abstract class PluginManagerThatSupportMultiLoader
extends BaseDynamicPluginManager
implements PluginManagerImpl {
    private static final Logger mLogger = LoggerFactory.getLogger(PluginManagerThatUseDynamicLoader.class);
    protected MultiLoaderPpsController mPpsController;
    protected PluginLoader mPluginLoader;

    public PluginManagerThatSupportMultiLoader(Context context) {
        super(context);
    }

    public abstract String getPluginKey();

    protected void onPluginServiceConnected(ComponentName name, IBinder service) {
        block9: {
            this.mPpsController = MultiLoaderPluginProcessService.wrapBinder((IBinder)service);
            try {
                this.mPpsController.setUuidManagerForPlugin(this.getPluginKey(), (IBinder)new UuidManagerBinder((UuidManagerImpl)this));
            }
            catch (DeadObjectException e) {
                if (mLogger.isErrorEnabled()) {
                    mLogger.error("onServiceConnected RemoteException:" + (Object)((Object)e));
                }
            }
            catch (RemoteException e) {
                if (((Object)((Object)e)).getClass().getSimpleName().equals("TransactionTooLargeException")) {
                    if (mLogger.isErrorEnabled()) {
                        mLogger.error("onServiceConnected TransactionTooLargeException:" + (Object)((Object)e));
                    }
                }
                throw new RuntimeException(e);
            }
            try {
                IBinder iBinder = this.mPpsController.getPluginLoaderForPlugin(this.getPluginKey());
                if (iBinder != null) {
                    this.mPluginLoader = new BinderPluginLoader(iBinder);
                }
            }
            catch (RemoteException ignored) {
                if (!mLogger.isErrorEnabled()) break block9;
                mLogger.error("onServiceConnected mPpsController getPluginLoader:", (Throwable)ignored);
            }
        }
    }

    protected void onPluginServiceDisconnected(ComponentName name) {
        this.mPpsController = null;
        this.mPluginLoader = null;
    }

    public final void loadRunTime(String uuid) throws RemoteException, FailedException {
        if (mLogger.isInfoEnabled()) {
            mLogger.info("loadRunTime mPpsController:" + this.mPpsController);
        }
        PpsStatus ppsStatus = this.mPpsController.getPpsStatusForPlugin(this.getPluginKey());
        if (!ppsStatus.runtimeLoaded) {
            this.mPpsController.loadRuntimeForPlugin(this.getPluginKey(), uuid);
        }
    }

    public final void loadPluginLoader(String uuid) throws RemoteException, FailedException {
        if (mLogger.isInfoEnabled()) {
            mLogger.info("loadPluginLoader mPluginLoader:" + this.mPluginLoader);
        }
        if (this.mPluginLoader == null) {
            PpsStatus ppsStatus = this.mPpsController.getPpsStatusForPlugin(this.getPluginKey());
            if (!ppsStatus.loaderLoaded) {
                this.mPpsController.loadPluginLoaderForPlugin(this.getPluginKey(), uuid);
            }
            IBinder iBinder = this.mPpsController.getPluginLoaderForPlugin(this.getPluginKey());
            this.mPluginLoader = new BinderPluginLoader(iBinder);
        }
    }
}

