package com.xdja.spider.admin.service;

import com.xdja.spider.core.bean.Article;
import org.jfaster.mango.plugin.page.Page;

import java.util.List;

/**
 * TODO 增加注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017-07-12 15:57:23
 */
public interface IArticleService {

    /**
     * 保存Article
     * @param article
     * @return 保存成功后的主键ID
     */
    long save(Article article);

    /**
     * 修改Article
     * @param article
     */
    void update(Article article);

    /**
     * 根据ID获取Article
     * @param id
     * @return
     */
    Article get(Long id);

    /**
     * 分页获取
     * @param colId
     * @param page
     * @return
     */
    List<Article> list(Long colId, String searchKey, Long publisherId, Page page);

    /**
     * 根据ID删除Article
     * @param id 要删除的Article主键ID
     */
    void del(Long id);

    /**
     * 获取最大批次
     * @param colId
     */
    int getMaxBatch(Long colId);

    /**
     * 根据栏目ID删除文章
     * @param colId
     */
    void delByColId(Long colId);

    /**
     * 修改文章发布状态
     * @param colId
     * @param status
     */
    void updateReleaseStatusByColId(Long colId, int status);

    /**
     * 删除静态化时间
     * @param columnId
     */
    void delStaticTime(Long columnId);


}