package com.xdja.spider.admin.service;

import com.xdja.spider.core.bean.Column;
import org.jfaster.mango.plugin.page.Page;

import java.util.List;

/**
 * 栏目接口
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/12 上午9:42
 */
public interface IColumnService {

    /**
     * 保存Column
     * @param column
     * @return 保存成功后的主键ID
     */
    long save(Column column);

    /**
     * 批量保存Column
     * @param columns
     */
    void save(List<Column> columns);

    /**
     * 修改Column
     * @param column
     */
    void update(Column column);

    /**
     * 根据ID获取Column
     * @param id
     * @return
     */
    Column get(Long id);

    /**
     * 获取Column列表
     * @return
     */
    List<Column> list();

    /**
     * 根据发布者ID获取栏目列表
     * @param publisherId
     * @return
     */
    List<Column> list(long publisherId);

    List<Column> list(long publisherId, int type);

    /**
     * 分页获取Column列表
     * @param publisherId
     * @param searchKey
     * @param page
     * @return
     */
    List<Column> list(Long publisherId, String searchKey, Page page);

    /**
     * 获取抓取列表
     * @return
     */
    List<Column> grabList();

    /**
     * 根据ID删除Column
     * @param id 要删除的Column主键ID
     */
    void del(Long id);

    /**
     * 修改栏目启用禁用状态
     * @param columnId
     * @param status
     */
    void changeStatus(long columnId, int status);

    /**
     * 修改栏目的访问权限 公开非公开
     * @param id
     * @param value
     */
    void changeAccss(Long id, int value);

}