package com.xdja.spider.admin.service;

import com.xdja.spider.core.bean.Publisher;
import org.jfaster.mango.plugin.page.Page;

import java.util.List;

public interface IPublisherService {

    /**
     * 保存Publisher
     * @param publisher
     * @return 保存成功后的主键ID
     */
    long save(Publisher publisher);

    /**
     * 批量保存Publisher
     * @param publishers
     */
    void save(List<Publisher> publishers);

    /**
     * 修改Publisher
     * @param publisher
     */
    void update(Publisher publisher);

    /**
     * 根据ID获取Publisher
     * @param id
     * @return
     */
    Publisher get(Long id);

    /**
     * 根据账户密码获取发布者
     *
     * @param account
     * @param password
     * @return
     */
    Publisher get(String account, String password);

    /**
     * 根据账户获取发布者
     * @param account
     * @return
     */
    Publisher get(String account);

    /**
     * 获取Publisher列表
     * @return
     */
    List<Publisher> list();

    /**
     * 分页获取列表数据
     * @param searchKey
     * @param page
     * @return
     */
    List<Publisher> list(String searchKey, Page page);

    /**
     * 根据ID删除Publisher
     * @param id 要删除的Publisher主键ID
     */
    void del(Long id);

    /**
     * 重置发布者密码
     * @param publisherId
     */
    void restPassword(long publisherId);

    /**
     * 修改发布者状态
     * @param publisherId
     * @param status
     */
    void changeStatus(long publisherId, int status);
}