package com.xdja.spider.admin.control;

import com.xdja.spider.admin.bean.Cons;
import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IArticleImgService;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IGrabConfService;
import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.ArticleImg;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.grab.GrabDetail;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.*;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.jfaster.mango.plugin.page.Page;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 文章管理
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/5 上午10:48
 */
@RestController
@RequestMapping("/publisher/article")
public class ArticleControl extends BaseControl {

    @Autowired
    private IGrabConfService grabConfService;

    @Autowired
    private IArticleService articleService;

    @Autowired
    private IArticleImgService articleImgService;

    @RequestMapping("list")
    public BaseResponse list(@RequestBody ListRequestBean requestBean, HttpServletRequest request) {
        long pId = (long) request.getAttribute(Cons.LOGIN_REQUEST_ATTR);
        int pageNum = IntUtil.null2default(requestBean.getPageNum(), Pagination.DEFAULT_PAGE_NUM);
        int pageSize = IntUtil.null2default(requestBean.getPageSize(), Pagination.DEFAULT_PAGE_SIZE);
        Page page = Page.create(pageNum, pageSize);
        List<Article> list = this.articleService.list(requestBean.getColId(), requestBean.getSearchKey(), pId, page);
        return this.createSuccess(Pagination.create(pageNum, pageSize, page.getTotal(), list));
    }

    @RequestMapping(value = "get/{id}", method = RequestMethod.GET)
    public BaseResponse get(@PathVariable Long id) {
        Article article = this.articleService.get(id);
        return this.createSuccess(article);
    }

    @RequestMapping(value = "del/{id}", method = RequestMethod.GET)
    public BaseResponse del(@PathVariable Long id) {
        try {
            this.articleService.del(id);
        } catch (Exception e) {
            logger.error("删除文章出错", e);
            return this.createFail("删除文章出错");
        }
        return this.createSuccess(SUCCESS);
    }

    /**
     * 发布文章
     * @param id
     * @return
     */
    @RequestMapping(value = "release/{id}", method = RequestMethod.POST)
    public BaseResponse release(@PathVariable Long id) {
        try {
            Article article = this.articleService.get(id);
            article.setReleaseStatus(Article.ReleaseStatus.RELEASE.value);
            article.setReleaseTime(System.currentTimeMillis());
            this.articleService.update(article);

            //TODO hsun 静态化页面

        } catch (Exception e) {
            logger.error("发布文章出错", e);
            return this.createFail("发布文章出错");
        }
        return this.createSuccess(SUCCESS);
    }

    /**
     * 关闭文章
     * @param id
     * @return
     */
    @RequestMapping(value = "close/{id}", method = RequestMethod.POST)
    public BaseResponse close(@PathVariable Long id) {
        try {
            Article article = this.articleService.get(id);
            article.setReleaseStatus(Article.ReleaseStatus.CLOSE.value);
            this.articleService.update(article);
        } catch (Exception e) {
            logger.error("关闭文章出错", e);
            return this.createFail("关闭文章出错");
        }
        return this.createSuccess(SUCCESS);
    }


    @RequestMapping(value = "update", method = RequestMethod.POST)
    public BaseResponse update(@RequestBody Article article) {
        try {

            this.articleService.update(article);

            List<String> imgs = GrabUtil.grabImgs(article.getContent());
            List<ArticleImg> articleImgs = new ArrayList<>();
            for (String img : imgs) {
                ArticleImg articleImg = new ArticleImg();
                articleImg.setArticleId(article.getId());
                articleImg.setImgUrl(img);

                articleImgs.add(articleImg);
            }

            this.articleImgService.del(article.getId());
            this.articleImgService.save(articleImgs);

        } catch (BeansException e) {
            logger.error("修改失败", e);
            this.createFail("修改失败");
        }
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping("save")
    public BaseResponse save(@RequestBody Article article) {
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String sn = UUIDUtil.random();

        article.setCreateTime(System.currentTimeMillis());
        article.setSn(sn);
        article.setViewUrl(String.format("/%s/%s/%s.html", article.getColumnId(), today, sn));

        if (article.getReleaseStatus() == Article.ReleaseStatus.RELEASE.value) {
            article.setReleaseTime(System.currentTimeMillis());
        }

        List<String> imgs = GrabUtil.grabImgs(article.getContent());

        long id = this.articleService.save(article);

        List<ArticleImg> articleImgs = new ArrayList<>();
        for (String img : imgs) {
            ArticleImg articleImg = new ArticleImg();
            articleImg.setArticleId(id);
            articleImg.setImgUrl(img);

            articleImgs.add(articleImg);
        }

        this.articleImgService.save(articleImgs);

        return this.createSuccess(this.articleService.get(id));
    }

    @RequestMapping("grab/again/{id}")
    public BaseResponse grabAgain(@PathVariable Long id) {
        Article article = this.articleService.get(id);
        GrabConf grabConf = this.grabConfService.getByColumnId(article.getColumnId());
        try {
            GrabDetail grabDetail = GrabUtil.grabDetail(article.getSourceUrl(), grabConf);
            article.setTitle(grabDetail.getTitle());
            article.setContent(grabDetail.getContent());
            article.setDescription(grabDetail.getDescription());

            this.articleService.update(article);
        } catch (IOException e) {
            logger.error("抓取失败", e);
            return this.createFail("抓取失败");
        }
        return this.createSuccess(SUCCESS);
    }

}
