package com.xdja.spider.admin.control;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.producer.SuperTransmitter;
import com.xdja.sc.model.Msg;
import com.xdja.spider.admin.bean.Cons;
import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IGrabConfService;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.admin.service.IGrabScriptService;
import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.util.UUIDUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 栏目管理
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/5 上午10:37
 */
@RestController
@RequestMapping("/publisher/column/")
public class ColumnControl extends BaseControl {

    @Autowired
    private IColumnService columnService;

    @Autowired
    private IGrabConfService grabConfService;

    @Autowired
    private IGrabScriptService grabScriptService;

    @Autowired
    private IArticleService articleService;

    @RequestMapping("myList")
    public BaseResponse list(HttpServletRequest request) {
        long pId = (long) request.getAttribute(Cons.LOGIN_REQUEST_ATTR);
        List<Column> list = this.columnService.list(pId);
        return this.createSuccess(list);
    }

    @RequestMapping("myManualList")
    public BaseResponse manual(HttpServletRequest request) {
        long pId = (long) request.getAttribute(Cons.LOGIN_REQUEST_ATTR);
        List<Column> list = this.columnService.list(pId, Column.Type.MANUAL.value);
        return this.createSuccess(list);
    }

    @RequestMapping("list")
    public BaseResponse list(@RequestBody ListRequestBean requestBean, HttpServletRequest request) {
        long pId = (long) request.getAttribute(Cons.LOGIN_REQUEST_ATTR);
        int pageNum = IntUtil.null2default(requestBean.getPageNum(), Pagination.DEFAULT_PAGE_NUM);
        int pageSize = IntUtil.null2default(requestBean.getPageSize(), Pagination.DEFAULT_PAGE_SIZE);
        Page page = Page.create(pageNum, pageSize);
        List<Column> list = this.columnService.list(pId, requestBean.getSearchKey(), page);
        return this.createSuccess(Pagination.create(pageNum, pageSize, page.getTotal(), list));
    }

    @RequestMapping(value = "save", method = RequestMethod.POST)
    public BaseResponse save(@RequestBody Column column, HttpServletRequest request) {
        long pId = (long) request.getAttribute(Cons.LOGIN_REQUEST_ATTR);
        column.setPublisherId(pId);
        long columnId = this.columnService.save(column);
        column.setId(columnId);
        return this.createSuccess(column);
    }
    //
    @RequestMapping(value = "update", method = RequestMethod.POST)
    public BaseResponse update(@RequestBody Column column) {
        try {
            this.columnService.update(column);
        } catch (Exception e) {
            logger.error("修改失败", e);
            return this.createFail("修改失败");
        }
        return this.createSuccess(SUCCESS);
    }


    @RequestMapping(value = "get/{id}", method = RequestMethod.GET)
    public BaseResponse get(@PathVariable Long id) {
        Column column = this.columnService.get(id);
        if (null == column) {
            this.createFail("栏目不存在");
        }
        return this.createSuccess(column);
    }

    @RequestMapping(value = "disable/{id}", method = RequestMethod.GET)
    public BaseResponse disable(@PathVariable Long id) {
        this.columnService.changeStatus(id, Column.Status.DISABLE.value);
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping(value = "enable/{id}", method = RequestMethod.GET)
    public BaseResponse enable(@PathVariable Long id) {
        this.columnService.changeStatus(id, Column.Status.ENABLE.value);
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping(value = "private/{id}", method = RequestMethod.GET)
    public BaseResponse changePrivate(@PathVariable Long id) {
        this.columnService.changeAccss(id, Column.Access.PRIVATE.value);
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping(value = "public/{id}", method = RequestMethod.GET)
    public BaseResponse changePublic(@PathVariable Long id) {
        this.columnService.changeAccss(id, Column.Access.PUBLIC.value);
        return this.createSuccess(SUCCESS);
    }


    //******************************配置******************************

    @RequestMapping(value = "grabconf/get/{columnId}", method = RequestMethod.GET)
    public BaseResponse getColumnGrabConf(@PathVariable long columnId) {
        GrabConf grabConf = this.grabConfService.getByColumnId(columnId);
        return this.createSuccess(grabConf);
    }

    @RequestMapping(value = "grabconf/save", method = RequestMethod.POST)
    public BaseResponse saveGrabConf(@RequestBody GrabConf grabConf) {
        if (null != grabConf.getId()) {
            this.grabConfService.update(grabConf);
        } else {
            this.grabConfService.save(grabConf);
        }

        if (grabTest(grabConf)) {
            return this.createSuccess(SUCCESS);
        } else {
            return this.createFail("抓取失败，请检查配置");
        }
    }


    @RequestMapping(value = "grabscript/get/{columnId}", method = RequestMethod.GET)
    public BaseResponse getGrabScript(@PathVariable long columnId) {
        GrabScript grabScript = this.grabScriptService.getByColId(columnId);
        return this.createSuccess(grabScript);
    }

    @RequestMapping(value = "grabscript/save", method = RequestMethod.POST)
    public BaseResponse saveGrabScript(@RequestBody GrabScript script) {
        if (null != script.getId()) {
            this.grabScriptService.update(script);
        } else {
            this.grabScriptService.save(script);
        }

        Column column = this.columnService.get(script.getColumnId());
        try {
            SuperTransmitter.getInstance().sendMessage(Rmq.TOPIC_GRAB_SPECIAL_START, new Msg(UUIDUtil.random(), MQSetting.Queue, System.currentTimeMillis(), column.getSn() , null));
        } catch (Exception e) {
            logger.error("启动特殊抓取失败", e);
            return this.createFail("启动特殊抓取失败");
        }
        return this.createSuccess(SUCCESS);
    }

    //******************************抓取******************************

    /**
     * 手动触发抓取
     * @param columnId
     * @return
     */
    @RequestMapping(value = "grab/{columnId}")
    public BaseResponse grab(@PathVariable Long columnId) {
        Column column = this.columnService.get(columnId);
        String topic = null;
        try {
            if (column.getType() == Column.Type.GENERAL.value) {
                topic = Rmq.TOPIC_GRAB_GENERAL;
            } else if (column.getType() == Column.Type.SPECIAL.value) {
                GrabScript grabScript = this.grabScriptService.getByColId(columnId);
                topic = String.format(Rmq.TOPIC_GRAB_SPECIAL, column.getSn(), grabScript.getVersion());
            }
            int maxBatch = this.articleService.getMaxBatch(columnId);
            SuperTransmitter.getInstance().sendMessage(topic, new Msg(UUIDUtil.random(), MQSetting.Queue, System.currentTimeMillis(), String.format("%s#%s", columnId, maxBatch + 1), null));
        } catch (Exception e) {
            logger.error("启动抓取失败", e);
            this.createFail("启动抓取失败");
        }
        return this.createSuccess(SUCCESS);
    }

    /**
     * 清空列表，重新抓取数据
     * @param columnId
     * @return
     */
    @RequestMapping(value = "grab/{columnId}/again")
    public BaseResponse grabAgain(@PathVariable Long columnId) {
        this.articleService.delByColId(columnId);
        return this.grab(columnId);
    }

    /**
     * 清空详情，重新抓取详情
     * @param columnId
     * @return
     */
    @RequestMapping(value = "grab/{columnId}/detail/again")
    public BaseResponse grabDetailAgain(@PathVariable Long columnId) {
        this.articleService.updateReleaseStatusByColId(columnId, Article.ReleaseStatus.CLOSE.value);
        return this.grab(columnId);
    }

    /**
     * 重新静态化
     * @param columnId
     * @return
     */
    @RequestMapping(value = "static/{columnId}/again")
    public BaseResponse staticAgain(@PathVariable Long columnId) {
        this.articleService.delStaticTime(columnId);
        return this.grab(columnId);
    }

    /**
     * 抓取测试
     * @param grabConf
     * @return
     */
    private boolean grabTest(GrabConf grabConf) {
        try {
            List<Article> grabLists = GrabUtil.grabList(grabConf, 1);
            if (CollectionUtils.isEmpty(grabLists)) {
                return false;
            }
        } catch (Exception e) {
            logger.error("抓取测试失败", e);
            return false;
        }
        return true;
    }

}
