package com.xdja.spider.admin.control;

import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IPublisherService;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/admin/publisher/")
public class PublisherControl extends BaseControl {

    @Autowired
    private IPublisherService publisherService;

    /**
     * 分页获取发布者
     * @param requestBean
     * @return
     */
    @RequestMapping("list")
    public BaseResponse list(@RequestBody ListRequestBean requestBean) {
        logger.debug("获取发布者列表");
        int pageNum = IntUtil.null2default(requestBean.getPageNum(), Pagination.DEFAULT_PAGE_NUM);
        int pageSize = IntUtil.null2default(requestBean.getPageSize(), Pagination.DEFAULT_PAGE_SIZE);
        Page page = Page.create(pageNum, pageSize);
        List<Publisher> list = this.publisherService.list(requestBean.getSearchKey(), page);
        return this.createSuccess(Pagination.create(pageNum, pageSize, page.getTotal(), list));
    }

    /**
     * 保存发布者
     * @param publisher
     */
    @RequestMapping(value = "save", method = RequestMethod.POST)
    public BaseResponse save(@RequestBody Publisher publisher) {
        logger.debug("保存发布者");
        Publisher pub = this.publisherService.get(publisher.getAccount());
        if (null != pub) {//账户已经存在
            return this.createFail("账户已经存在");
        }
        long publisherId = this.publisherService.save(publisher);
        publisher.setId(publisherId);

        return this.createSuccess(publisher);
    }

    /**
     * 修改发布者
     * @param publisher
     */
    @RequestMapping(value = "update", method = RequestMethod.POST)
    public BaseResponse update(@RequestBody Publisher publisher) {
        logger.debug("修改发布者");
        this.publisherService.update(publisher);
        return this.createSuccess(SUCCESS);
    }

    /**
     * 获取发布者
     * @param id
     * @return
     */
    @RequestMapping(value = "get/{id}", method = RequestMethod.GET)
    public BaseResponse get(@PathVariable Long id) {
        Publisher publisher = this.publisherService.get(id);
        if (null == publisher) {
            return this.createFail("发布者不存在");
        }
        return this.createSuccess(publisher);
    }

    /**
     * 删除发布者
     * @param id
     */
    @RequestMapping(value = "del/{id}", method = RequestMethod.GET)
    public BaseResponse del(@PathVariable Long id) {
        this.publisherService.del(id);
        return this.createSuccess(SUCCESS);
    }

    /**
     * 重置发布者密码
     * @param publisherId
     */
    @RequestMapping(value = "restPwd/{publisherId}", method = RequestMethod.GET)
    public BaseResponse restPassword(@PathVariable long publisherId) {
        logger.debug("重置发布者登录密码");
        this.publisherService.restPassword(publisherId);
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping(value = "disable/{publisherId}", method = RequestMethod.GET)
    public BaseResponse disable(@PathVariable long publisherId) {
        this.publisherService.changeStatus(publisherId, Publisher.Status.DISABLE.value);
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping(value = "enable/{publisherId}", method = RequestMethod.GET)
    public BaseResponse enable(@PathVariable long publisherId) {
        this.publisherService.changeStatus(publisherId, Publisher.Status.ENABLE.value);
        return this.createSuccess(SUCCESS);
    }
}
