package com.xdja.spider.admin.control;

import com.xdja.spider.admin.service.ISysConfService;
import com.xdja.spider.core.bean.SysConf;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统配置控制类
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/12 下午2:20
 */
@RestController
@RequestMapping("/admin/sysconf/")
public class SysConfControl extends BaseControl {

    @Autowired
    private ISysConfService sysConfService;

    @RequestMapping(value = "list", method = RequestMethod.GET)
    public BaseResponse list() {
        List<SysConf> list = this.sysConfService.list();
        return this.createSuccess(list);
    }

    @RequestMapping(value = "get", method = RequestMethod.GET)
    public SysConf get(Long id) {
        return this.sysConfService.get(id);
    }

    @RequestMapping(value = "update", method = RequestMethod.POST)
    public BaseResponse update(@RequestBody SysConf sysConf) {
        try {
            this.sysConfService.update(sysConf);
        } catch (Exception e) {
            logger.error("修改配置出错", e);
            return this.createFail("修改配置出错");
        }
        return this.createSuccess(SUCCESS);
    }
}
