package com.xdja.spider.admin.control;

import com.alibaba.fastjson.JSON;
import com.xdja.spider.admin.bean.Cons;
import com.xdja.spider.admin.service.IPublisherService;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.util.EncryptUtil;
import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.RedisUtil;
import com.xdja.spider.core.util.UUIDUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 登录管理
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/5 上午10:50
 */
@RestController
public class SysControl extends BaseControl {

    @Autowired
    private IPublisherService publisherService;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * 登录系统
     * @param account
     * @param password
     * @return
     */
    @RequestMapping(value = "/sys/login", method = RequestMethod.POST)
    public BaseResponse login(String account, String password) {

        final Publisher publisher = publisherService.get(account, EncryptUtil.encodeSHA1(password));
        if (null == publisher) {//发布者不存在 或账户密码错误 一律提示账户密码错误
            return this.createFail("账户或密码错误");
        }
        if (publisher.getStatus() == Publisher.Status.DISABLE.value) {
            return this.createFail("账户被停用，请联系管理员");
        }

        final String ticket = UUIDUtil.random();
        Map<String, Object> map = new HashMap<String, Object>(){
            private static final long serialVersionUID = -3027995260117310290L;
            {
                put("ticket", ticket);
                put("publisher", publisher);
            }
        };

        redisUtil.STRINGS.set(Cons.REDIS_PREFIX_LOGIN_USER + ticket, JSON.toJSONString(publisher), 30);
        return this.createSuccess(map);
    }

    /**
     * 退出系统
     * @param request
     * @return
     */
    @RequestMapping(value = "/sys/logout", method = RequestMethod.GET)
    public BaseResponse logout(HttpServletRequest request) {
        String ticket = request.getHeader(Cons.LOGIN_REQUEST_TICKET_HEADER);
        redisUtil.delete(Cons.REDIS_PREFIX_LOGIN_USER + ticket);
        return this.createSuccess(SUCCESS);
    }


    /**
     * 获取文件上传链接，30分钟有效
     * @return
     */
    @RequestMapping(value = "/sys/getUploadUrl", method = RequestMethod.GET)
    public BaseResponse getUploadUrl() {
        return this.createSuccess(FastDFSUtil.getUploadUrl(30));
    }

}
