package com.xdja.spider.admin.exception;

import com.fasterxml.jackson.core.JsonParseException;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/5 下午1:56
 */
@ControllerAdvice
public class BaseExceptionHandler extends BaseControl {

//    @ExceptionHandler(Exception.class)
//    @ResponseBody
//    public BaseResponse handleException(Exception exception) {
////        return this.createFail(ErrorMessage.create("服务器内部错误", exception.getMessage()));
//        return this.createFail("服务器内部错误");
//    }

    @ExceptionHandler(ArithmeticException.class)
    @ResponseBody
    public BaseResponse handleException(ArithmeticException exception) {
        return this.createFail(exception.getMessage());
    }

    @ExceptionHandler(JsonParseException.class)
    @ResponseBody
    public BaseResponse handleException(JsonParseException exception) {
        return this.createFail("JSON解析出错");
    }

}
