package com.xdja.spider.admin.exception;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/5 下午1:57
 */
public class ErrorMessage {

    /**
     * 服务标识
     */
    private String hostId;

    /**
     * 请求唯一标识
     */
    private String requestId;

    /**
     * 错误代码
     */
    private String errorCode;

    /**
     * 错误描述
     */
    private String message;

    /**
     * 无参构造
     */
    public ErrorMessage() {}

    /**
     * 有参构造器
     * @param errorCode 异常代码
     * @param message 错误描述
     */
    public ErrorMessage(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    /**
     * 有参构造器
     * @param hostId 服务唯一标识
     * @param requestId 请求唯一标识
     * @param errorCode 异常代码
     * @param message 错误描述
     */
    public ErrorMessage(String hostId, String requestId, String errorCode, String message) {
        this.hostId = hostId;
        this.requestId = requestId;
        this.errorCode = errorCode;
        this.message = message;
    }

    public static ErrorMessage create(String errorCode, String message){
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorCode(errorCode);
        errorMessage.setMessage(message);
        return errorMessage;
    }

    public String getHostId() {
        return hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
