package com.xdja.spider.admin.filter;

import com.alibaba.fastjson.JSON;
import com.xdja.spider.admin.bean.Cons;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.util.RedisUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * token过滤器
 *
 * @author hsun
 * @version 1.0
 * @since 2017/8/17 上午10:46
 */
@WebFilter(filterName = "publisherTokenFilter", value = {"/publisher/*"})
public class PublisherTokenFilter implements Filter {

    private static Logger logger = LoggerFactory.getLogger(PublisherTokenFilter.class);

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(this,
                filterConfig.getServletContext());
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (checkTicket(request)) {
            logger.debug("验证ticket成功");
            chain.doFilter(request, response);
        } else {
            logger.debug("验证ticket失败");
            response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            return;
        }
    }

    @Override
    public void destroy() {

    }

    private boolean checkTicket(HttpServletRequest request) {
        //1.获取ticket
        String ticket = request.getHeader(Cons.LOGIN_REQUEST_TICKET_HEADER);
        if (StringUtils.isBlank(ticket)) {
            logger.debug("请求头信息中未携带ticket");
            return false;
        }

        //2.获取ticket对应登录信息
        String ticketInfoStr = redisUtil.STRINGS.get(Cons.REDIS_PREFIX_LOGIN_USER + ticket);
        if (StringUtils.isBlank(ticketInfoStr)) {
            logger.debug("获取ticket对应登录信息不存在");
            return false;
        }

        Publisher publisher = JSON.parseObject(ticketInfoStr, Publisher.class);
        if (publisher.getType() != Publisher.Type.PUBLISHER.value) {
            logger.debug("用户权限不足");
            return false;
        }
        request.setAttribute(Cons.LOGIN_REQUEST_ATTR, publisher.getId());

        //延长
        redisUtil.STRINGS.set(Cons.REDIS_PREFIX_LOGIN_USER + ticket, ticketInfoStr, 30);
        logger.debug("ticket验证通过");
        return true;
    }
}
