package com.xdja.spider.admin.filter;

import com.xdja.spider.admin.service.ISysConfService;
import com.xdja.spider.core.bean.SysConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 系统配置前端js
 *
 * @author hsun
 * @version 1.0
 * @since 2017/8/19 下午2:24
 */
@WebFilter(filterName = "spiderConfFilter", value = {"/spiderConf.js"})
public class SpiderConfFilter implements Filter {

    @Autowired
    private ISysConfService sysConfService;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext(this,
                filterConfig.getServletContext());
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SysConf sysConf = sysConfService.get("FASTDFS_URL");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;

        String basePath = String.format("%s://%s:%s/%s", request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());

        response.setContentType("application/javascript");
        response.setCharacterEncoding("UTF-8");

        String config = new StringBuilder("var spiderConf = {")
                .append("\n    basePath:'").append(basePath).append("'")
                .append(",\n    fastdfsUrl:'").append(sysConf.getValue()).append("'")
                .append("\n}")
                .toString();
        response.getOutputStream().write(config.getBytes());

    }

    @Override
    public void destroy() {

    }
}
