package com.xdja.spider.admin.init;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.spider.admin.task.GrabJob;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.UUIDUtil;
import org.quartz.*;
import org.quartz.impl.StdScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

import java.util.Properties;

/**
 * 管理平台初始化
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/26 下午4:28
 */
@Service
public class AdminInit implements InitializingBean {

    private static Logger logger = LoggerFactory.getLogger(AdminInit.class);

    @Autowired
    private Scheduler scheduler;

    @Override
    public void afterPropertiesSet() throws Exception {
        Properties properties = PropertiesLoaderUtils.loadAllProperties("system.properties");
        String url = properties.getProperty("rmq.url");
        String username = properties.getProperty("rmq.username");
        String password = properties.getProperty("rmq.password");
        String queueName = properties.getProperty("rmq.queue.name");
        String threadSize = properties.getProperty("rmq.thread.size");

//        if (null == MQSetting.url) {}
        logger.debug("##########################");
        logger.debug("初始化RMQ:{}",url);
        MQSetting.init(username, password, url, queueName);
        MQSetting.setCodec(Rmq.CODEC);
        MQSetting.setThreadSize(Integer.parseInt(threadSize));

        String fastdfsHost = properties.getProperty("fastdfs.host");
        String fastdfsUserId = properties.getProperty("fastdfs.user.id");
        String fastdfsUserSecret = properties.getProperty("fastdfs.user.secret");
        logger.debug("##########################");
        logger.debug("初始化FastDFS:{}",fastdfsHost);
        FastDFSUtil.init(fastdfsHost, fastdfsUserId, fastdfsUserSecret);

        String key = UUIDUtil.random();
        String cron = properties.getProperty("cron.expression");
        logger.debug("##########################");
        logger.debug("定时任务开启:key【{}】，cron【{}】", key, cron);

        System.setProperty("org.terracotta.quartz.skipUpdateCheck","true");
        JobDetail jobDetail = JobBuilder.newJob(GrabJob.class).withIdentity(key).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(cron);
        CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity(key).withSchedule(cronScheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, trigger);
    }
}
