package com.xdja.spider.admin.task;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.producer.SuperTransmitter;
import com.xdja.sc.model.Msg;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.admin.service.IGrabScriptService;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.core.util.UUIDUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/8/8 上午10:05
 */
@Component
public class GrabJob implements Job {

    private static Logger logger = LoggerFactory.getLogger(GrabJob.class);

    @Autowired
    private IColumnService columnService;

    @Autowired
    private IArticleService articleService;

    @Autowired
    private IGrabScriptService grabScriptService;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.debug("定时任务开启");
        List<Column> list = columnService.grabList();
        for (Column column : list) {
            String topic = null;
            try {
                if (column.getType() == Column.Type.GENERAL.value) {
                    topic = Rmq.TOPIC_GRAB_GENERAL;
                } else if (column.getType() == Column.Type.SPECIAL.value) {
                    GrabScript grabScript = this.grabScriptService.getByColId(column.getId());
                    topic = String.format(Rmq.TOPIC_GRAB_SPECIAL, column.getSn(), grabScript.getVersion());
                }

                int maxBatch = articleService.getMaxBatch(column.getId());
                SuperTransmitter.getInstance().sendMessage(topic, new Msg(UUIDUtil.random(), MQSetting.Queue, System.currentTimeMillis(), String.format("%s#%s", column.getId(), maxBatch + 1), null));
            } catch (Exception e) {
                logger.error("RMQ消息发送失败", e);
            }

        }
    }
}
