package com.xdja.spider.admin.task;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.producer.SuperTransmitter;
import com.xdja.sc.model.Msg;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.core.util.UUIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 抓取定时
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/27 上午9:20
 */
//@Component
public class GrabTask {

    private static Logger logger = LoggerFactory.getLogger(GrabTask.class);

    @Autowired
    private IColumnService columnService;

    @Autowired
    private IArticleService articleService;

//    @Scheduled(cron = "0 0 0/3 * * ?")
    public void grab() {
        logger.debug("定时任务开启");
        List<Column> list = columnService.grabList();
        for (Column column : list) {
            String topic = null;
            try {
                if (column.getType() == Column.Type.GENERAL.value) {
                    topic = Rmq.TOPIC_GRAB_GENERAL;
                } else if (column.getType() == Column.Type.SPECIAL.value) {
                    topic = String.format(Rmq.TOPIC_GRAB_SPECIAL, column.getSn());
                }

                int maxBatch = articleService.getMaxBatch(column.getId());
                SuperTransmitter.getInstance().sendMessage(topic, new Msg(UUIDUtil.random(), MQSetting.Queue, System.currentTimeMillis(), String.format("%s#%s", column.getId(), maxBatch + 1), null));
            } catch (Exception e) {
                logger.error("RMQ消息发送失败", e);
            }

        }
    }
}
