/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.control;

import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IArticleImgService;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IGrabConfService;
import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.ArticleImg;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.grab.GrabDetail;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.util.UUIDUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publisher/article"})
public class ArticleControl
extends BaseControl {
    @Autowired
    private IGrabConfService grabConfService;
    @Autowired
    private IArticleService articleService;
    @Autowired
    private IArticleImgService articleImgService;

    @RequestMapping(value={"list"})
    public BaseResponse list(@RequestBody ListRequestBean requestBean, HttpServletRequest request) {
        long pId = (Long)request.getAttribute("pId");
        int pageNum = IntUtil.null2default((Integer)requestBean.getPageNum(), (int)1);
        int pageSize = IntUtil.null2default((Integer)requestBean.getPageSize(), (int)10);
        Page page = Page.create((int)pageNum, (int)pageSize);
        List list = this.articleService.list(requestBean.getColId(), requestBean.getSearchKey(), Long.valueOf(pId), page);
        return this.createSuccess(Pagination.create((int)pageNum, (int)pageSize, (int)page.getTotal(), (List)list));
    }

    @RequestMapping(value={"get/{id}"}, method={RequestMethod.GET})
    public BaseResponse get(@PathVariable Long id) {
        Article article = this.articleService.get(id);
        return this.createSuccess(article);
    }

    @RequestMapping(value={"del/{id}"}, method={RequestMethod.GET})
    public BaseResponse del(@PathVariable Long id) {
        try {
            this.articleService.del(id);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u6587\u7ae0\u51fa\u9519", (Throwable)e);
            return this.createFail("\u5220\u9664\u6587\u7ae0\u51fa\u9519");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"release/{id}"}, method={RequestMethod.POST})
    public BaseResponse release(@PathVariable Long id) {
        try {
            Article article = this.articleService.get(id);
            article.setReleaseStatus(Article.ReleaseStatus.RELEASE.value);
            article.setReleaseTime(Long.valueOf(System.currentTimeMillis()));
            this.articleService.update(article);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u5e03\u6587\u7ae0\u51fa\u9519", (Throwable)e);
            return this.createFail("\u53d1\u5e03\u6587\u7ae0\u51fa\u9519");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"close/{id}"}, method={RequestMethod.POST})
    public BaseResponse close(@PathVariable Long id) {
        try {
            Article article = this.articleService.get(id);
            article.setReleaseStatus(Article.ReleaseStatus.CLOSE.value);
            this.articleService.update(article);
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u6587\u7ae0\u51fa\u9519", (Throwable)e);
            return this.createFail("\u5173\u95ed\u6587\u7ae0\u51fa\u9519");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public BaseResponse update(@RequestBody Article article) {
        try {
            this.articleService.update(article);
            List imgs = GrabUtil.grabImgs((String)article.getContent());
            ArrayList<ArticleImg> articleImgs = new ArrayList<ArticleImg>();
            for (String img : imgs) {
                ArticleImg articleImg = new ArticleImg();
                articleImg.setArticleId(article.getId());
                articleImg.setImgUrl(img);
                articleImgs.add(articleImg);
            }
            this.articleImgService.del(article.getId().longValue());
            this.articleImgService.save(articleImgs);
        }
        catch (BeansException e) {
            this.logger.error("\u4fee\u6539\u5931\u8d25", (Throwable)e);
            this.createFail("\u4fee\u6539\u5931\u8d25");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"save"})
    public BaseResponse save(@RequestBody Article article) {
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String sn = UUIDUtil.random();
        article.setCreateTime(System.currentTimeMillis());
        article.setSn(sn);
        article.setViewUrl(String.format("/%s/%s/%s.html", article.getColumnId(), today, sn));
        if (article.getReleaseStatus() == Article.ReleaseStatus.RELEASE.value) {
            article.setReleaseTime(Long.valueOf(System.currentTimeMillis()));
        }
        List imgs = GrabUtil.grabImgs((String)article.getContent());
        long id = this.articleService.save(article);
        ArrayList<ArticleImg> articleImgs = new ArrayList<ArticleImg>();
        for (String img : imgs) {
            ArticleImg articleImg = new ArticleImg();
            articleImg.setArticleId(Long.valueOf(id));
            articleImg.setImgUrl(img);
            articleImgs.add(articleImg);
        }
        this.articleImgService.save(articleImgs);
        return this.createSuccess(this.articleService.get(Long.valueOf(id)));
    }

    @RequestMapping(value={"grab/again/{id}"})
    public BaseResponse grabAgain(@PathVariable Long id) {
        Article article = this.articleService.get(id);
        GrabConf grabConf = this.grabConfService.getByColumnId(article.getColumnId());
        try {
            GrabDetail grabDetail = GrabUtil.grabDetail((String)article.getSourceUrl(), (GrabConf)grabConf);
            article.setTitle(grabDetail.getTitle());
            article.setContent(grabDetail.getContent());
            article.setDescription(grabDetail.getDescription());
            this.articleService.update(article);
        }
        catch (IOException e) {
            this.logger.error("\u6293\u53d6\u5931\u8d25", (Throwable)e);
            return this.createFail("\u6293\u53d6\u5931\u8d25");
        }
        return this.createSuccess("success");
    }
}

