/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.filter;

import com.alibaba.fastjson.JSON;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.util.RedisUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@WebFilter(filterName="publisherTokenFilter", value={"/publisher/*"})
public class PublisherTokenFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(PublisherTokenFilter.class);
    @Autowired
    private RedisUtil redisUtil;

    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.checkTicket(request)) {
            logger.debug("\u9a8c\u8bc1ticket\u5931\u8d25");
            response.setStatus(401);
            return;
        }
        logger.debug("\u9a8c\u8bc1ticket\u6210\u529f");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private boolean checkTicket(HttpServletRequest request) {
        String ticket = request.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            logger.debug("\u8bf7\u6c42\u5934\u4fe1\u606f\u4e2d\u672a\u643a\u5e26ticket");
            return false;
        }
        String ticketInfoStr = this.redisUtil.STRINGS.get("_spider-login-user_" + ticket);
        if (StringUtils.isBlank((CharSequence)ticketInfoStr)) {
            logger.debug("\u83b7\u53d6ticket\u5bf9\u5e94\u767b\u5f55\u4fe1\u606f\u4e0d\u5b58\u5728");
            return false;
        }
        Publisher publisher = (Publisher)JSON.parseObject((String)ticketInfoStr, Publisher.class);
        if (publisher.getType() != Publisher.Type.PUBLISHER.value) {
            logger.debug("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return false;
        }
        request.setAttribute("pId", (Object)publisher.getId());
        this.redisUtil.STRINGS.set("_spider-login-user_" + ticket, ticketInfoStr, 30);
        logger.debug("ticket\u9a8c\u8bc1\u901a\u8fc7");
        return true;
    }
}

