/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.filter;

import com.xdja.spider.admin.service.ISysConfService;
import com.xdja.spider.core.bean.SysConf;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@WebFilter(filterName="spiderConfFilter", value={"/spiderConf.js"})
public class SpiderConfFilter
implements Filter {
    @Autowired
    private ISysConfService sysConfService;

    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SysConf sysConf = this.sysConfService.get("FASTDFS_URL");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String basePath = String.format("%s://%s:%s/%s", request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        response.setContentType("application/javascript");
        response.setCharacterEncoding("UTF-8");
        String config = "var spiderConf = {" + "\n    basePath:'" + basePath + "'" + ",\n    fastdfsUrl:'" + sysConf.getValue() + "'" + "\n}";
        response.getOutputStream().write(config.getBytes());
    }

    public void destroy() {
    }
}

