/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.control;

import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.admin.service.IGrabConfService;
import com.xdja.spider.admin.service.IGrabScriptService;
import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.util.RedisUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publisher/column/"})
public class ColumnControl
extends BaseControl {
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IGrabConfService grabConfService;
    @Autowired
    private IGrabScriptService grabScriptService;
    @Autowired
    private IArticleService articleService;
    @Autowired
    private RedisUtil redisUtil;

    @RequestMapping(value={"myList"})
    public BaseResponse list(HttpServletRequest request) {
        long pId = (Long)request.getAttribute("pId");
        List list = this.columnService.list(pId);
        return this.createSuccess(list);
    }

    @RequestMapping(value={"myManualList"})
    public BaseResponse manual(HttpServletRequest request) {
        long pId = (Long)request.getAttribute("pId");
        List list = this.columnService.list(pId, Column.Type.MANUAL.value);
        return this.createSuccess(list);
    }

    @RequestMapping(value={"list"})
    public BaseResponse list(@RequestBody ListRequestBean requestBean, HttpServletRequest request) {
        long pId = (Long)request.getAttribute("pId");
        int pageNum = IntUtil.null2default((Integer)requestBean.getPageNum(), (int)1);
        int pageSize = IntUtil.null2default((Integer)requestBean.getPageSize(), (int)10);
        Page page = Page.create((int)pageNum, (int)pageSize);
        List list = this.columnService.list(Long.valueOf(pId), requestBean.getSearchKey(), page);
        return this.createSuccess(Pagination.create((int)pageNum, (int)pageSize, (int)page.getTotal(), (List)list));
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public BaseResponse save(@RequestBody Column column, HttpServletRequest request) {
        long pId = (Long)request.getAttribute("pId");
        column.setPublisherId(Long.valueOf(pId));
        long columnId = this.columnService.save(column);
        column.setId(Long.valueOf(columnId));
        return this.createSuccess(column);
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public BaseResponse update(@RequestBody Column column) {
        try {
            this.columnService.update(column);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u5931\u8d25", (Throwable)e);
            return this.createFail("\u4fee\u6539\u5931\u8d25");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"get/{id}"}, method={RequestMethod.GET})
    public BaseResponse get(@PathVariable Long id) {
        Column column = this.columnService.get(id);
        if (null == column) {
            this.createFail("\u680f\u76ee\u4e0d\u5b58\u5728");
        }
        return this.createSuccess(column);
    }

    @RequestMapping(value={"disable/{id}"}, method={RequestMethod.GET})
    public BaseResponse disable(@PathVariable Long id) {
        this.columnService.changeStatus(id.longValue(), Column.Status.DISABLE.value);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"enable/{id}"}, method={RequestMethod.GET})
    public BaseResponse enable(@PathVariable Long id) {
        this.columnService.changeStatus(id.longValue(), Column.Status.ENABLE.value);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"private/{id}"}, method={RequestMethod.GET})
    public BaseResponse changePrivate(@PathVariable Long id) {
        this.columnService.changeAccss(id, Column.Access.PRIVATE.value);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"public/{id}"}, method={RequestMethod.GET})
    public BaseResponse changePublic(@PathVariable Long id) {
        this.columnService.changeAccss(id, Column.Access.PUBLIC.value);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"grabconf/get/{columnId}"}, method={RequestMethod.GET})
    public BaseResponse getColumnGrabConf(@PathVariable long columnId) {
        GrabConf grabConf = this.grabConfService.getByColumnId(Long.valueOf(columnId));
        return this.createSuccess(grabConf);
    }

    @RequestMapping(value={"grabconf/save"}, method={RequestMethod.POST})
    public BaseResponse saveGrabConf(@RequestBody GrabConf grabConf) {
        if (null != grabConf.getId()) {
            this.grabConfService.update(grabConf);
        } else {
            this.grabConfService.save(grabConf);
        }
        if (this.grabTest(grabConf)) {
            return this.createSuccess("success");
        }
        return this.createFail("\u6293\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
    }

    @RequestMapping(value={"grabscript/get/{columnId}"}, method={RequestMethod.GET})
    public BaseResponse getGrabScript(@PathVariable long columnId) {
        GrabScript grabScript = this.grabScriptService.getByColId(Long.valueOf(columnId));
        return this.createSuccess(grabScript);
    }

    @RequestMapping(value={"grabscript/save"}, method={RequestMethod.POST})
    public BaseResponse saveGrabScript(@RequestBody GrabScript script) {
        if (null != script.getId()) {
            this.grabScriptService.update(script);
        } else {
            this.grabScriptService.save(script);
        }
        Column column = this.columnService.get(script.getColumnId());
        try {
            this.redisUtil.PUBSUB.send("grab.special.start", (Object)column.getSn());
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u7279\u6b8a\u6293\u53d6\u5931\u8d25", (Throwable)e);
            return this.createFail("\u542f\u52a8\u7279\u6b8a\u6293\u53d6\u5931\u8d25");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"grab/{columnId}"})
    public BaseResponse grab(@PathVariable Long columnId) {
        Column column = this.columnService.get(columnId);
        String topic = null;
        try {
            if (column.getType() == Column.Type.GENERAL.value) {
                topic = "grab.general";
            } else if (column.getType() == Column.Type.SPECIAL.value) {
                GrabScript grabScript = this.grabScriptService.getByColId(columnId);
                topic = String.format("grab.special.%s.v%s", column.getSn(), grabScript.getVersion());
            }
            int maxBatch = this.articleService.getMaxBatch(columnId);
            this.redisUtil.PUBSUB.send(topic, (Object)String.format("%s#%s", columnId, maxBatch + 1));
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u6293\u53d6\u5931\u8d25", (Throwable)e);
            this.createFail("\u542f\u52a8\u6293\u53d6\u5931\u8d25");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"grab/{columnId}/again"})
    public BaseResponse grabAgain(@PathVariable Long columnId) {
        this.articleService.delByColId(columnId);
        return this.grab(columnId);
    }

    @RequestMapping(value={"grab/{columnId}/detail/again"})
    public BaseResponse grabDetailAgain(@PathVariable Long columnId) {
        this.articleService.updateReleaseStatusByColId(columnId, Article.ReleaseStatus.CLOSE.value);
        return this.grab(columnId);
    }

    @RequestMapping(value={"static/{columnId}/again"})
    public BaseResponse staticAgain(@PathVariable Long columnId) {
        this.articleService.delStaticTime(columnId);
        return this.grab(columnId);
    }

    private boolean grabTest(GrabConf grabConf) {
        try {
            List grabLists = GrabUtil.grabList((GrabConf)grabConf, (int)1);
            if (CollectionUtils.isEmpty((Collection)grabLists)) {
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6293\u53d6\u6d4b\u8bd5\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }
}

