/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.init;

import com.xdja.spider.admin.service.ISysConfService;
import com.xdja.spider.admin.task.GrabJob;
import com.xdja.spider.core.bean.SysConf;
import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.UUIDUtil;
import java.util.Properties;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminInit
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(AdminInit.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ISysConfService sysConfService;

    public void afterPropertiesSet() throws Exception {
        Properties properties = PropertiesLoaderUtils.loadAllProperties((String)"system.properties");
        String fastdfsHost = properties.getProperty("fastdfs.host");
        String fastdfsUserId = properties.getProperty("fastdfs.user.id");
        String fastdfsUserSecret = properties.getProperty("fastdfs.user.secret");
        String forwarddownhost = properties.getProperty("forward.down.host");
        logger.debug("##########################");
        logger.debug("\u521d\u59cb\u5316FastDFS:{}", (Object)fastdfsHost);
        FastDFSUtil.init((String)forwarddownhost, (String)fastdfsHost, (String)fastdfsUserId, (String)fastdfsUserSecret);
        SysConf cronExpression = this.sysConfService.get("CRON_EXPRESSION");
        String key = UUIDUtil.random();
        String cron = cronExpression.getValue();
        logger.debug("##########################");
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f:key\u3010{}\u3011\uff0ccron\u3010{}\u3011", (Object)key, (Object)cron);
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
        JobDetail jobDetail = JobBuilder.newJob(GrabJob.class).withIdentity(key).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(key).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }
}

