package com.xdja.spider.collect.control;

import com.xdja.spider.collect.bean.Collect;
import com.xdja.spider.collect.bean.ListReqBean;
import com.xdja.spider.collect.service.ICollectService;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/8/24 上午10:37
 */
@RestController
@RequestMapping("/collect/")
public class CollectControl extends BaseControl {

    @Autowired
    private ICollectService collectService;

    @RequestMapping(value = "save", method = RequestMethod.POST)
    public BaseResponse save(@RequestBody Collect collect) {
        try {
            this.collectService.save(collect);
        } catch (Exception e) {
            logger.error("收藏失败", e);
            return this.createFail("收藏失败");
        }
        logger.info("用户[{}]收藏了[{}]", collect.getUid(), collect.getAsn());
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping("del/{id}")
    public BaseResponse del(@PathVariable Long id) {
        try {
            this.collectService.del(id);
        } catch (Exception e) {
            logger.error("删除收藏失败", e);
            return this.createFail("删除收藏失败");
        }
        return this.createSuccess(SUCCESS);
    }

    @RequestMapping("list")
    public BaseResponse getByUID(@RequestBody ListReqBean reqBean) {
        int pageNum = IntUtil.null2default(reqBean.getPageNum(), Pagination.DEFAULT_PAGE_NUM);
        int pageSize = IntUtil.null2default(reqBean.getPageSize(), Pagination.DEFAULT_PAGE_SIZE);
        Page page = Page.create(pageNum, pageSize);
        List<Collect> collects = this.collectService.getByUID(reqBean.getUid(), page);
        return this.createSuccess(Pagination.create(pageNum, pageSize, page.getTotal(), collects));
    }

}
