/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.collect.control;

import com.xdja.spider.collect.bean.Collect;
import com.xdja.spider.collect.bean.ListReqBean;
import com.xdja.spider.collect.service.ICollectService;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collect/"})
public class CollectControl
extends BaseControl {
    @Autowired
    private ICollectService collectService;

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public BaseResponse save(@RequestBody Collect collect) {
        try {
            this.collectService.save(collect);
        }
        catch (Exception e) {
            this.logger.error("\u6536\u85cf\u5931\u8d25", (Throwable)e);
            return this.createFail("\u6536\u85cf\u5931\u8d25");
        }
        this.logger.info("\u7528\u6237[{}]\u6536\u85cf\u4e86[{}]", (Object)collect.getUid(), (Object)collect.getAsn());
        return this.createSuccess("success");
    }

    @RequestMapping(value={"del/{id}"})
    public BaseResponse del(@PathVariable Long id) {
        try {
            this.collectService.del(id.longValue());
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u6536\u85cf\u5931\u8d25", (Throwable)e);
            return this.createFail("\u5220\u9664\u6536\u85cf\u5931\u8d25");
        }
        return this.createSuccess("success");
    }

    @RequestMapping(value={"list"})
    public BaseResponse getByUID(@RequestBody ListReqBean reqBean) {
        int pageNum = IntUtil.null2default((Integer)reqBean.getPageNum(), (int)1);
        int pageSize = IntUtil.null2default((Integer)reqBean.getPageSize(), (int)10);
        Page page = Page.create((int)pageNum, (int)pageSize);
        List collects = this.collectService.getByUID(reqBean.getUid(), page);
        return this.createSuccess(Pagination.create((int)pageNum, (int)pageSize, (int)page.getTotal(), (List)collects));
    }
}

