package com.xdja.spider.robot.grab;

import com.rabbitmq.client.Channel;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.model.Msg;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.core.cons.Rmq;
import com.xdja.spider.robot.service.ISpiderRobotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * RMQ回调
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/26 下午7:43
 */
@Component
public class GrabAction extends ReceivedAction {

    private static Logger logger = LoggerFactory.getLogger(GrabAction.class);

    @Autowired
    private ISpiderRobotService spiderRobotService;

    private ExecutorService pool = Executors.newFixedThreadPool(5);

    @Override
    public void delivery(Msg msg, long deliveryTag, Channel channel, boolean autoAck) {
        try {
            String type = msg.type;
            String content = msg.content;
            logger.debug("消息内容：{}", content);

            if(type.equals(Rmq.TOPIC_GRAB_GENERAL)) {
                String[] split = content.split("#");
                long colId = Long.parseLong(split[0]);
                int maxBatch = Integer.parseInt(split[1]);
                pool.execute(new GrabHandle(spiderRobotService, colId, maxBatch));
            } else if (type.equals(Rmq.TOPIC_GRAB_SPECIAL_START)) {//重启特殊抓取
                GrabScript grabScript = this.spiderRobotService.getGrabScript(content);
                ScriptHandle.handle(content, grabScript);
            } else if (type.equals(Rmq.TOPIC_GRAB_SPECIAL_HANDLE)) {//特殊抓取数据处理
                new SpecialHandle(spiderRobotService, Long.parseLong(content)).handle();
            }

            if (!autoAck) {
                channel.basicAck(deliveryTag, true);
            }
        } catch (Exception e) {
            logger.error("消息处理失败", e);
        }

    }
}
